/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hash;

import java.io.Serializable;

public final class MurmurHash3
implements Serializable {
    private static final long serialVersionUID = 0L;

    private MurmurHash3() {
    }

    public static long[] hash(long[] key, long seed) {
        HashState hashState = new HashState(seed, seed);
        int longs = key.length;
        int nblocks = longs >> 1;
        for (int i = 0; i < nblocks; ++i) {
            long k1 = key[2 * i];
            long k2 = key[2 * i + 1];
            hashState.blockMix128(k1, k2);
        }
        int tail = nblocks * 2;
        int rem = longs - tail;
        long k1 = rem == 0 ? 0L : key[tail];
        return hashState.finalMix128(k1, 0L, longs * 8);
    }

    public static long[] hash(int[] key, long seed) {
        HashState hashState = new HashState(seed, seed);
        int ints = key.length;
        int nblocks = ints >> 2;
        for (int i = 0; i < nblocks; ++i) {
            long k1 = MurmurHash3.getLong(key, 4 * i, 2);
            long k2 = MurmurHash3.getLong(key, 4 * i + 2, 2);
            hashState.blockMix128(k1, k2);
        }
        int tail = nblocks * 4;
        int rem = ints - tail;
        long k1 = 0L;
        long k2 = 0L;
        if (rem > 2) {
            k1 = MurmurHash3.getLong(key, tail, 2);
            k2 = MurmurHash3.getLong(key, tail + 2, rem - 2);
        } else {
            k1 = rem == 0 ? 0L : MurmurHash3.getLong(key, tail, rem);
        }
        return hashState.finalMix128(k1, k2, ints * 4);
    }

    public static long[] hash(byte[] key, long seed) {
        HashState hashState = new HashState(seed, seed);
        int bytes = key.length;
        int nblocks = bytes >> 4;
        for (int i = 0; i < nblocks; ++i) {
            long k1 = MurmurHash3.getLong(key, 16 * i, 8);
            long k2 = MurmurHash3.getLong(key, 16 * i + 8, 8);
            hashState.blockMix128(k1, k2);
        }
        int tail = nblocks * 16;
        int rem = bytes - tail;
        long k1 = 0L;
        long k2 = 0L;
        if (rem > 8) {
            k1 = MurmurHash3.getLong(key, tail, 8);
            k2 = MurmurHash3.getLong(key, tail + 8, rem - 8);
        } else {
            k1 = rem == 0 ? 0L : MurmurHash3.getLong(key, tail, rem);
        }
        return hashState.finalMix128(k1, k2, bytes);
    }

    private static long getLong(byte[] bArr, int index, int rem) {
        long out = 0L;
        int i = rem;
        while (i-- > 0) {
            byte b = bArr[index + i];
            out ^= ((long)b & 0xFFL) << i * 8;
        }
        return out;
    }

    private static long getLong(int[] intArr, int index, int rem) {
        long out = 0L;
        int i = rem;
        while (i-- > 0) {
            int v = intArr[index + i];
            out ^= ((long)v & 0xFFFFFFFFL) << i * 32;
        }
        return out;
    }

    private static final class HashState {
        private static final long C1 = -8663945395140668459L;
        private static final long C2 = 5545529020109919103L;
        private long h1;
        private long h2;

        HashState(long h1, long h2) {
            this.h1 = h1;
            this.h2 = h2;
        }

        void blockMix128(long k1, long k2) {
            this.h1 ^= HashState.mixK1(k1);
            this.h1 = Long.rotateLeft(this.h1, 27);
            this.h1 += this.h2;
            this.h1 = this.h1 * 5L + 1390208809L;
            this.h2 ^= HashState.mixK2(k2);
            this.h2 = Long.rotateLeft(this.h2, 31);
            this.h2 += this.h1;
            this.h2 = this.h2 * 5L + 944331445L;
        }

        long[] finalMix128(long k1, long k2, long inputLengthBytes) {
            this.h1 ^= HashState.mixK1(k1);
            this.h2 ^= HashState.mixK2(k2);
            this.h1 ^= inputLengthBytes;
            this.h2 ^= inputLengthBytes;
            this.h1 += this.h2;
            this.h2 += this.h1;
            this.h1 = HashState.finalMix64(this.h1);
            this.h2 = HashState.finalMix64(this.h2);
            this.h1 += this.h2;
            this.h2 += this.h1;
            return new long[]{this.h1, this.h2};
        }

        private static long finalMix64(long h) {
            h ^= h >>> 33;
            h *= -49064778989728563L;
            h ^= h >>> 33;
            h *= -4265267296055464877L;
            h ^= h >>> 33;
            return h;
        }

        private static long mixK1(long k1) {
            k1 *= -8663945395140668459L;
            k1 = Long.rotateLeft(k1, 31);
            return k1 *= 5545529020109919103L;
        }

        private static long mixK2(long k2) {
            k2 *= 5545529020109919103L;
            k2 = Long.rotateLeft(k2, 33);
            return k2 *= -8663945395140668459L;
        }
    }
}

