/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.QuickSelect;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.memory.MemoryRequest;
import com.yahoo.sketches.memory.MemoryUtil;
import com.yahoo.sketches.memory.NativeMemory;
import com.yahoo.sketches.theta.DirectUpdateSketch;
import com.yahoo.sketches.theta.HashOperations;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.ResizeFactor;
import com.yahoo.sketches.theta.UpdateReturnState;
import com.yahoo.sketches.theta.UpdateSketch;

class DirectQuickSelectSketch
extends DirectUpdateSketch {
    static final int DQS_MIN_LG_ARR_LONGS = 5;
    static final int DQS_MIN_LG_NOM_LONGS = 4;
    static final double DQS_REBUILD_THRESHOLD = 0.9375;
    static final double DQS_RESIZE_THRESHOLD = 0.9375;
    private final Family MY_FAMILY;
    private final int preambleLongs_;
    private Memory mem_;
    private final MemoryRequest memReq_;
    private int lgArrLongs_;
    private int hashTableThreshold_;
    private int curCount_;
    private long thetaLong_;
    private boolean empty_;
    private final boolean dirty_ = false;

    DirectQuickSelectSketch(int lgNomLongs, long seed, float p, ResizeFactor rf, Memory dstMem, boolean unionGadget) {
        super(lgNomLongs, seed, p, rf);
        int minReqBytes;
        int myPreambleLongs;
        if (this.lgNomLongs_ < 4) {
            DirectQuickSelectSketch.freeMem(dstMem);
            throw new IllegalArgumentException("This sketch requires a minimum nominal entries of 16");
        }
        this.mem_ = dstMem;
        if (unionGadget) {
            myPreambleLongs = Family.UNION.getMinPreLongs();
            this.MY_FAMILY = Family.UNION;
        } else {
            myPreambleLongs = Family.QUICKSELECT.getMinPreLongs();
            this.MY_FAMILY = Family.QUICKSELECT;
        }
        this.memReq_ = dstMem.getMemoryRequest();
        int myLgArrLongs = DirectQuickSelectSketch.startingSubMultiple(this.lgNomLongs_ + 1, rf, 5);
        long curCapBytes = dstMem.getCapacity();
        int n = minReqBytes = this.memReq_ == null ? DirectQuickSelectSketch.getFullCapBytes(this.lgNomLongs_, myPreambleLongs) : DirectQuickSelectSketch.getRequiredBytes(myLgArrLongs, myPreambleLongs);
        if (curCapBytes < (long)minReqBytes) {
            DirectQuickSelectSketch.freeMem(dstMem);
            throw new IllegalArgumentException("Memory capacity is too small: " + curCapBytes + " < " + minReqBytes);
        }
        byte byte0 = (byte)(myPreambleLongs | rf.lg() << 6);
        this.preambleLongs_ = myPreambleLongs;
        this.mem_.putByte(0L, byte0);
        this.mem_.putByte(1L, (byte)3);
        this.mem_.putByte(2L, (byte)this.MY_FAMILY.getID());
        this.mem_.putByte(3L, (byte)this.lgNomLongs_);
        this.setLgArrLongs(myLgArrLongs);
        this.empty_ = true;
        this.mem_.putByte(5L, (byte)4);
        this.mem_.putShort(6L, PreambleUtil.computeSeedHash(seed));
        this.setCurCount(0);
        this.mem_.putFloat(12L, p);
        this.setThetaLong((long)((double)p * 9.223372036854776E18));
        this.hashTableThreshold_ = DirectQuickSelectSketch.setHashTableThreshold(this.lgNomLongs_, this.lgArrLongs_);
        this.mem_.clear(this.preambleLongs_ << 3, 8 << this.lgArrLongs_);
    }

    DirectQuickSelectSketch(Memory srcMem, long seed) {
        super(srcMem.getByte(3L), seed, srcMem.getFloat(12L), ResizeFactor.getRF(srcMem.getByte(0L) >>> 6 & 3));
        short seedHashMem = srcMem.getShort(6L);
        short seedHashArg = PreambleUtil.computeSeedHash(seed);
        PreambleUtil.checkSeedHashes(seedHashMem, seedHashArg);
        byte familyID = srcMem.getByte(2L);
        if (familyID == Family.UNION.getID()) {
            this.preambleLongs_ = Family.UNION.getMinPreLongs() & 0x3F;
            this.MY_FAMILY = Family.UNION;
        } else {
            this.preambleLongs_ = Family.QUICKSELECT.getMinPreLongs() & 0x3F;
            this.MY_FAMILY = Family.QUICKSELECT;
        }
        this.thetaLong_ = srcMem.getLong(16L);
        this.lgArrLongs_ = srcMem.getByte(4L);
        long curCapBytes = srcMem.getCapacity();
        int minReqBytes = DirectQuickSelectSketch.getRequiredBytes(this.lgArrLongs_, this.preambleLongs_);
        if (curCapBytes < (long)minReqBytes) {
            DirectQuickSelectSketch.freeMem(srcMem);
            throw new IllegalArgumentException("Possible corruption: Current Memory size < min required size: " + curCapBytes + " < " + minReqBytes);
        }
        if (this.lgArrLongs_ <= this.lgNomLongs_ && this.thetaLong_ < Long.MAX_VALUE) {
            DirectQuickSelectSketch.freeMem(srcMem);
            throw new IllegalArgumentException("Possible corruption: Theta cannot be < 1.0 and lgArrLongs <= lgNomLongs. " + this.lgArrLongs_ + " <= " + this.lgNomLongs_ + ", Theta: " + this.getTheta());
        }
        this.hashTableThreshold_ = DirectQuickSelectSketch.setHashTableThreshold(this.lgNomLongs_, this.lgArrLongs_);
        this.curCount_ = srcMem.getInt(8L);
        this.empty_ = srcMem.isAnyBitsSet(5L, (byte)4);
        this.mem_ = srcMem;
        this.memReq_ = srcMem.getMemoryRequest();
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        return this.curCount_;
    }

    @Override
    public boolean isEmpty() {
        return this.empty_;
    }

    @Override
    public byte[] toByteArray() {
        int lengthBytes = this.preambleLongs_ + (1 << this.lgArrLongs_) << 3;
        byte[] byteArray = new byte[lengthBytes];
        NativeMemory mem = new NativeMemory(byteArray);
        MemoryUtil.copy(this.mem_, 0L, mem, 0L, lengthBytes);
        return byteArray;
    }

    @Override
    public UpdateSketch rebuild() {
        if (this.getRetainedEntries(true) > 1 << this.getLgNomLongs()) {
            this.quickSelectAndRebuild();
        }
        return this;
    }

    @Override
    public final void reset() {
        int arrLongs = 1 << this.getLgArrLongs();
        Memory mem = this.getMemory();
        int preBytes = this.preambleLongs_ << 3;
        mem.clear(preBytes, arrLongs * 8);
        this.mem_.putByte(5L, (byte)4);
        this.empty_ = true;
        this.setCurCount(0);
        float p = mem.getFloat(12L);
        this.setThetaLong((long)((double)p * 9.223372036854776E18));
    }

    @Override
    int getPreambleLongs() {
        return this.preambleLongs_;
    }

    @Override
    long[] getCache() {
        long[] cacheArr = new long[1 << this.lgArrLongs_];
        NativeMemory mem = new NativeMemory(cacheArr);
        MemoryUtil.copy(this.mem_, this.preambleLongs_ << 3, mem, 0L, 8 << this.lgArrLongs_);
        return cacheArr;
    }

    @Override
    Memory getMemory() {
        return this.mem_;
    }

    @Override
    long getThetaLong() {
        return this.thetaLong_;
    }

    @Override
    boolean isDirty() {
        return false;
    }

    @Override
    int getLgArrLongs() {
        return this.lgArrLongs_;
    }

    @Override
    UpdateReturnState hashUpdate(long hash) {
        int preBytes;
        HashOperations.checkHashCorruption(hash);
        if (this.empty_) {
            this.mem_.clearBits(5L, (byte)4);
            this.empty_ = false;
        }
        if (HashOperations.continueCondition(this.thetaLong_, hash)) {
            return UpdateReturnState.RejectedOverTheta;
        }
        int lgArrLongs = this.getLgArrLongs();
        boolean inserted = HashOperations.hashInsert(this.mem_, lgArrLongs, hash, preBytes = this.preambleLongs_ << 3);
        if (inserted) {
            this.mem_.putInt(8L, ++this.curCount_);
            if (this.curCount_ > this.hashTableThreshold_) {
                long curCapBytes;
                int fullBytes;
                int curBytes = DirectQuickSelectSketch.getRequiredBytes(this.lgArrLongs_, this.preambleLongs_);
                if (curBytes >= (fullBytes = DirectQuickSelectSketch.getFullCapBytes(this.lgNomLongs_, this.preambleLongs_))) {
                    int lgNomLongs = this.getLgNomLongs();
                    assert (lgArrLongs == lgNomLongs + 1) : "lgArr: " + lgArrLongs + ", lgNom: " + lgNomLongs;
                    this.quickSelectAndRebuild();
                    return UpdateReturnState.InsertedCountIncremented;
                }
                int newLgArrLongs = this.lgArrLongs_ + 1;
                int reqBytes = DirectQuickSelectSketch.getRequiredBytes(newLgArrLongs, this.preambleLongs_);
                if ((long)reqBytes <= (curCapBytes = this.mem_.getCapacity())) {
                    this.resizeMe(newLgArrLongs);
                } else {
                    Memory newMem = this.memReq_.request(reqBytes);
                    if (newMem == null) {
                        throw new IllegalArgumentException("Requested memory cannot be null.");
                    }
                    long newCap = newMem.getCapacity();
                    if (newCap < (long)reqBytes) {
                        DirectQuickSelectSketch.freeMem(newMem);
                        throw new IllegalArgumentException("Requested memory not granted: " + newCap + " < " + reqBytes);
                    }
                    Memory oldMem = this.mem_;
                    this.moveAndResizeMe(newMem, newLgArrLongs);
                    this.memReq_.free(oldMem, newMem);
                }
            }
        }
        return UpdateReturnState.RejectedDuplicate;
    }

    private static final int getRequiredBytes(int lgArrLongs, int preambleLongs) {
        return (8 << lgArrLongs) + (preambleLongs << 3);
    }

    private static final int getFullCapBytes(int lgNomLongs, int preambleLongs) {
        return (16 << lgNomLongs) + (preambleLongs << 3);
    }

    private final void quickSelectAndRebuild() {
        int lgArrLongs = this.getLgArrLongs();
        int arrLongs = 1 << lgArrLongs;
        int pivot = (1 << this.getLgNomLongs()) + 1;
        long[] tmpArr = new long[arrLongs];
        int preBytes = this.preambleLongs_ << 3;
        Memory mem = this.getMemory();
        mem.getLongArray(preBytes, tmpArr, 0, arrLongs);
        this.setThetaLong(QuickSelect.selectExcludingZeros(tmpArr, this.getRetainedEntries(true), pivot));
        long[] tgtArr = new long[arrLongs];
        this.setCurCount(HashOperations.hashArrayInsert(tmpArr, tgtArr, lgArrLongs, this.getThetaLong()));
        mem.putLongArray(preBytes, tgtArr, 0, arrLongs);
    }

    private static final int setHashTableThreshold(int lgNomLongs, int lgArrLongs) {
        double fraction = lgArrLongs <= lgNomLongs ? 0.9375 : 0.9375;
        return (int)Math.floor(fraction * (double)(1 << lgArrLongs));
    }

    private final void moveAndResizeMe(Memory dstMem, int dstLgArrLongs) {
        int preBytes = this.preambleLongs_ << 3;
        MemoryUtil.copy(this.mem_, 0L, dstMem, 0L, preBytes);
        int srcHTLen = 1 << this.lgArrLongs_;
        long[] srcHTArr = new long[srcHTLen];
        this.mem_.getLongArray(this.preambleLongs_ << 3, srcHTArr, 0, srcHTLen);
        int dstHTLen = 1 << dstLgArrLongs;
        long[] dstHTArr = new long[dstHTLen];
        HashOperations.hashArrayInsert(srcHTArr, dstHTArr, dstLgArrLongs, this.thetaLong_);
        dstMem.putLongArray(preBytes, dstHTArr, 0, dstHTLen);
        this.mem_ = dstMem;
        this.setLgArrLongs(dstLgArrLongs);
        this.hashTableThreshold_ = DirectQuickSelectSketch.setHashTableThreshold(this.lgNomLongs_, this.lgArrLongs_);
    }

    private final void resizeMe(int newLgArrLongs) {
        int preBytes = this.preambleLongs_ << 3;
        int srcHTLen = 1 << this.lgArrLongs_;
        long[] srcHTArr = new long[srcHTLen];
        this.mem_.getLongArray(preBytes, srcHTArr, 0, srcHTLen);
        int dstHTLen = 1 << newLgArrLongs;
        long[] dstHTArr = new long[dstHTLen];
        HashOperations.hashArrayInsert(srcHTArr, dstHTArr, newLgArrLongs, this.thetaLong_);
        this.mem_.putLongArray(preBytes, dstHTArr, 0, dstHTLen);
        this.setLgArrLongs(newLgArrLongs);
        this.hashTableThreshold_ = DirectQuickSelectSketch.setHashTableThreshold(this.lgNomLongs_, this.lgArrLongs_);
    }

    private final void setLgArrLongs(int lgArrLongs) {
        this.lgArrLongs_ = lgArrLongs;
        this.mem_.putByte(4L, (byte)lgArrLongs);
    }

    private final void setThetaLong(long thetaLong) {
        this.thetaLong_ = thetaLong;
        this.mem_.putLong(16L, thetaLong);
    }

    private final void setCurCount(int curCount) {
        this.curCount_ = curCount;
        this.mem_.putInt(8L, curCount);
    }

    private static final void freeMem(Memory mem) {
        MemoryRequest memReq = mem.getMemoryRequest();
        if (memReq != null) {
            memReq.free(mem);
        } else if (mem instanceof NativeMemory) {
            ((NativeMemory)mem).freeMemory();
        }
    }
}

