/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.memory.Memory;

final class HashOperations {
    private static final int STRIDE_HASH_BITS = 7;
    static final int STRIDE_MASK = 127;

    private HashOperations() {
    }

    static int countPart(long[] srcArr, int lgArrLongs, long thetaLong) {
        int len;
        int cnt = 0;
        int i = len = 1 << lgArrLongs;
        while (i-- > 0) {
            long hash = srcArr[i];
            if (HashOperations.continueCondition(thetaLong, hash)) continue;
            ++cnt;
        }
        return cnt;
    }

    static int count(long[] srcArr, long thetaLong) {
        int len;
        int cnt = 0;
        int i = len = srcArr.length;
        while (i-- > 0) {
            long hash = srcArr[i];
            if (HashOperations.continueCondition(thetaLong, hash)) continue;
            ++cnt;
        }
        return cnt;
    }

    static int hashSearch(long[] hashTable, int lgArrLongs, long hash) {
        if (hash == 0L) {
            throw new IllegalArgumentException("Given hash cannot be zero: " + hash);
        }
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = 2 * (int)(hash >> lgArrLongs & 0x7FL) + 1;
        int curProbe = (int)(hash & (long)arrayMask);
        long curArrayHash = hashTable[curProbe];
        while (curArrayHash != hash && curArrayHash != 0L) {
            curProbe = curProbe + stride & arrayMask;
            curArrayHash = hashTable[curProbe];
        }
        return curArrayHash == hash ? curProbe : -1;
    }

    static int hashArrayInsert(long[] srcArr, long[] hashTable, int lgArrLongs, long thetaLong) {
        int count = 0;
        int arrLen = srcArr.length;
        HashOperations.checkThetaCorruption(thetaLong);
        for (int i = 0; i < arrLen; ++i) {
            long hash = srcArr[i];
            HashOperations.checkHashCorruption(hash);
            if (HashOperations.continueCondition(thetaLong, hash) || !HashOperations.hashInsert(hashTable, lgArrLongs, hash)) continue;
            ++count;
        }
        return count;
    }

    static boolean hashInsert(long[] hashTable, int lgArrLongs, long hash) {
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = 2 * (int)(hash >> lgArrLongs & 0x7FL) + 1;
        int curProbe = (int)(hash & (long)arrayMask);
        long curArrayHash = hashTable[curProbe];
        while (curArrayHash != hash && curArrayHash != 0L) {
            curProbe = curProbe + stride & arrayMask;
            curArrayHash = hashTable[curProbe];
        }
        if (curArrayHash == hash) {
            return false;
        }
        hashTable[curProbe] = hash;
        return true;
    }

    static boolean hashInsert(Memory mem, int lgArrLongs, long hash, int memOffsetBytes) {
        int arrayMask = (1 << lgArrLongs) - 1;
        int stride = 2 * (int)(hash >> lgArrLongs & 0x7FL) + 1;
        int curProbe = (int)(hash & (long)arrayMask);
        int curProbeOffsetBytes = (curProbe << 3) + memOffsetBytes;
        long curArrayHash = mem.getLong(curProbeOffsetBytes);
        while (curArrayHash != hash && curArrayHash != 0L) {
            curProbe = curProbe + stride & arrayMask;
            curProbeOffsetBytes = (curProbe << 3) + memOffsetBytes;
            curArrayHash = mem.getLong(curProbeOffsetBytes);
        }
        if (curArrayHash == hash) {
            return false;
        }
        mem.putLong(curProbeOffsetBytes, hash);
        return true;
    }

    static void checkThetaCorruption(long thetaLong) {
        if ((thetaLong | thetaLong - 1L) < 0L) {
            throw new IllegalStateException("Data Corruption: thetaLong was negative or zero: ThetaLong: " + thetaLong);
        }
    }

    static void checkHashCorruption(long hash) {
        if (hash < 0L) {
            throw new IllegalStateException("Data Corruption: hash was negative: Hash: " + hash);
        }
    }

    static boolean continueCondition(long thetaLong, long hash) {
        return (hash - 1L | thetaLong - hash - 1L) < 0L;
    }

    static void checkHashAndThetaCorruption(long thetaLong, long hash) {
        if ((hash | thetaLong | thetaLong - 1L) < 0L) {
            throw new IllegalStateException("Data Corruption: Either hash was negative or thetaLong was negative or zero: Hash: " + hash + ", ThetaLong: " + thetaLong);
        }
    }
}

