/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.sketches.Family;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.memory.NativeMemory;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.HashOperations;
import com.yahoo.sketches.theta.Intersection;
import com.yahoo.sketches.theta.PreambleUtil;
import com.yahoo.sketches.theta.SetOperation;
import com.yahoo.sketches.theta.Sketch;
import java.util.Arrays;

class HeapIntersection
extends SetOperation
implements Intersection {
    private static final Family MY_FAMILY = Family.INTERSECTION;
    private final short seedHash_;
    private final int lgNomLongs_;
    private int lgArrLongs_;
    private int hashTableThreshold_;
    private int curCount_;
    private long thetaLong_;
    private boolean empty_;
    private long[] hashTable_ = null;

    HeapIntersection(int lgNomLongs, long seed) {
        this.seedHash_ = HeapIntersection.computeSeedHash(seed);
        this.lgNomLongs_ = lgNomLongs;
        if (this.lgNomLongs_ < 4) {
            throw new IllegalArgumentException("This sketch requires a minimum nominal entries of 16");
        }
        this.lgArrLongs_ = this.lgNomLongs_ + 1;
        this.hashTableThreshold_ = HeapIntersection.setHashTableThreshold(this.lgArrLongs_);
        this.empty_ = false;
        this.curCount_ = -1;
        this.thetaLong_ = Long.MAX_VALUE;
    }

    HeapIntersection(Memory srcMem, long seed) {
        this.seedHash_ = HeapIntersection.computeSeedHash(seed);
        this.lgNomLongs_ = srcMem.getByte(3L);
        this.lgArrLongs_ = srcMem.getByte(4L);
        this.hashTableThreshold_ = HeapIntersection.setHashTableThreshold(this.lgArrLongs_);
        this.empty_ = srcMem.isAnyBitsSet(5L, (byte)4);
        this.curCount_ = srcMem.getInt(8L);
        this.thetaLong_ = srcMem.getLong(16L);
        int preambleLongs = srcMem.getByte(0L) & 0x3F;
        if (preambleLongs != 3) {
            throw new IllegalArgumentException("PreambleLongs must = 3.");
        }
        byte serVer = srcMem.getByte(1L);
        if (serVer != 3) {
            throw new IllegalArgumentException("Ser Version must = 3");
        }
        MY_FAMILY.checkFamilyID(srcMem.getByte(2L));
        if (this.curCount_ < 0) {
            this.empty_ = false;
            this.hashTable_ = null;
        } else if (this.empty_) {
            this.curCount_ = 0;
            this.hashTable_ = null;
        } else if (this.curCount_ == 0) {
            this.hashTable_ = null;
        } else {
            this.hashTable_ = new long[1 << this.lgArrLongs_];
            srcMem.getLongArray(24L, this.hashTable_, 0, 1 << this.lgArrLongs_);
        }
    }

    @Override
    public void update(Sketch sketchIn) {
        int skInState = sketchIn != null && sketchIn.getRetainedEntries(true) > 0 ? 1 : 0;
        int sw = (this.curCount_ < 0 ? 0 : 4) | (this.curCount_ <= 0 ? 0 : 2) | skInState;
        switch (sw) {
            case 0: {
                if (sketchIn != null) {
                    PreambleUtil.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
                    this.thetaLong_ = Math.min(this.thetaLong_, sketchIn.getThetaLong());
                    this.empty_ |= sketchIn.isEmpty();
                } else {
                    this.empty_ = true;
                }
                this.curCount_ = 0;
                this.hashTable_ = null;
                break;
            }
            case 1: {
                PreambleUtil.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
                this.thetaLong_ = Math.min(this.thetaLong_, sketchIn.getThetaLong());
                this.empty_ |= sketchIn.isEmpty();
                this.curCount_ = sketchIn.getRetainedEntries(true);
                this.lgArrLongs_ = HeapIntersection.computeMinLgArrLongsFromCount(this.curCount_, this.lgNomLongs_ + 1);
                this.hashTableThreshold_ = HeapIntersection.setHashTableThreshold(this.lgArrLongs_);
                this.hashTable_ = new long[1 << this.lgArrLongs_];
                this.moveToHT(sketchIn.getCache(), this.curCount_);
                break;
            }
            case 4: {
                if (sketchIn != null) {
                    PreambleUtil.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
                    this.thetaLong_ = Math.min(this.thetaLong_, sketchIn.getThetaLong());
                    this.empty_ |= sketchIn.isEmpty();
                } else {
                    this.empty_ = true;
                }
                this.hashTable_ = null;
                break;
            }
            case 5: {
                PreambleUtil.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
                this.thetaLong_ = Math.min(this.thetaLong_, sketchIn.getThetaLong());
                this.empty_ |= sketchIn.isEmpty();
                this.hashTable_ = null;
                break;
            }
            case 6: {
                if (sketchIn != null) {
                    PreambleUtil.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
                    this.thetaLong_ = Math.min(this.thetaLong_, sketchIn.getThetaLong());
                    this.empty_ |= sketchIn.isEmpty();
                } else {
                    this.empty_ = true;
                }
                this.curCount_ = 0;
                this.hashTable_ = null;
                break;
            }
            case 7: {
                PreambleUtil.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
                this.thetaLong_ = Math.min(this.thetaLong_, sketchIn.getThetaLong());
                this.empty_ |= sketchIn.isEmpty();
                this.performIntersect(sketchIn);
            }
        }
    }

    @Override
    public CompactSketch getResult(boolean dstOrdered, Memory dstMem) {
        if (this.curCount_ < 0) {
            throw new IllegalStateException("Calling getResult() with no intervening intersections is not a legal result.");
        }
        if (this.curCount_ == 0) {
            long[] compactCacheR = new long[]{};
            return CompactSketch.createCompactSketch(compactCacheR, this.empty_, this.seedHash_, this.curCount_, this.thetaLong_, dstOrdered, dstMem);
        }
        long[] compactCacheR = CompactSketch.compactCachePart(this.hashTable_, this.lgArrLongs_, this.curCount_, this.thetaLong_, dstOrdered);
        return CompactSketch.createCompactSketch(compactCacheR, this.empty_, this.seedHash_, this.curCount_, this.thetaLong_, dstOrdered, dstMem);
    }

    @Override
    public CompactSketch getResult() {
        return this.getResult(true, null);
    }

    @Override
    public boolean hasResult() {
        return this.curCount_ >= 0;
    }

    @Override
    public byte[] toByteArray() {
        int preBytes = 24;
        int dataBytes = this.hashTable_ != null ? 8 << this.lgArrLongs_ : 0;
        byte[] byteArrOut = new byte[preBytes + dataBytes];
        NativeMemory memOut = new NativeMemory(byteArrOut);
        memOut.putByte(0L, (byte)3);
        memOut.putByte(1L, (byte)3);
        memOut.putByte(2L, (byte)Family.objectToFamily(this).getID());
        memOut.putByte(3L, (byte)this.lgNomLongs_);
        memOut.putByte(4L, (byte)this.lgArrLongs_);
        if (this.empty_) {
            memOut.setBits(5L, (byte)4);
        } else {
            memOut.clearBits(5L, (byte)4);
        }
        memOut.putShort(6L, this.seedHash_);
        memOut.putInt(8L, this.curCount_);
        memOut.putFloat(12L, 1.0f);
        memOut.putLong(16L, this.thetaLong_);
        if (this.hashTable_ != null) {
            memOut.putLongArray(preBytes, this.hashTable_, 0, 1 << this.lgArrLongs_);
        }
        return byteArrOut;
    }

    @Override
    public void reset() {
        this.lgArrLongs_ = this.lgNomLongs_ + 1;
        Arrays.fill(this.hashTable_, 0L);
        this.curCount_ = -1;
        this.thetaLong_ = Long.MAX_VALUE;
        this.empty_ = false;
    }

    private void performIntersect(Sketch sketchIn) {
        assert (this.curCount_ > 0 && !this.empty_);
        long[] cacheIn = sketchIn.getCache();
        int arrLongsIn = cacheIn.length;
        long[] matchSet = new long[Math.min(this.curCount_, sketchIn.getRetainedEntries(true))];
        int matchSetCount = 0;
        if (sketchIn.isOrdered()) {
            for (int i = 0; i < arrLongsIn; ++i) {
                long hashIn = cacheIn[i];
                if (hashIn <= 0L) continue;
                if (hashIn < this.thetaLong_) {
                    int foundIdx = HashOperations.hashSearch(this.hashTable_, this.lgArrLongs_, hashIn);
                    if (foundIdx == -1) continue;
                    matchSet[matchSetCount++] = hashIn;
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < arrLongsIn; ++i) {
                int foundIdx;
                long hashIn = cacheIn[i];
                if (hashIn <= 0L || hashIn >= this.thetaLong_ || (foundIdx = HashOperations.hashSearch(this.hashTable_, this.lgArrLongs_, hashIn)) == -1) continue;
                matchSet[matchSetCount++] = hashIn;
            }
        }
        this.lgArrLongs_ = HeapIntersection.computeMinLgArrLongsFromCount(matchSetCount, this.lgArrLongs_);
        this.hashTableThreshold_ = HeapIntersection.setHashTableThreshold(this.lgArrLongs_);
        this.curCount_ = matchSetCount;
        Arrays.fill(this.hashTable_, 0, 1 << this.lgArrLongs_, 0L);
        this.moveToHT(matchSet, matchSetCount);
    }

    private void moveToHT(long[] arr, int count) {
        int arrLongsIn = arr.length;
        if (count > this.hashTableThreshold_) {
            throw new IllegalArgumentException("Intersection was not sized large enough: " + count);
        }
        int tmpCnt = 0;
        for (int i = 0; i < arrLongsIn; ++i) {
            long hashIn = arr[i];
            if (HashOperations.continueCondition(this.thetaLong_, hashIn)) continue;
            tmpCnt += HashOperations.hashInsert(this.hashTable_, this.lgArrLongs_, hashIn) ? 1 : 0;
        }
        assert (tmpCnt == count);
    }

    static final int setHashTableThreshold(int lgArrLongs) {
        double fraction = 0.9375;
        return (int)Math.floor(fraction * (double)(1 << lgArrLongs));
    }
}

