/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import com.google.common.primitives.Longs;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.histogram.ApproximateHistogram;
import io.druid.segment.FloatColumnSelector;
import java.util.Comparator;

public class ApproximateHistogramAggregator
implements Aggregator {
    public static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o, Object o1) {
            return Longs.compare((long)((ApproximateHistogram)o).count(), (long)((ApproximateHistogram)o1).count());
        }
    };
    private final String name;
    private final FloatColumnSelector selector;
    private final int resolution;
    private final float lowerLimit;
    private final float upperLimit;
    private ApproximateHistogram histogram;

    static Object combineHistograms(Object lhs, Object rhs) {
        return ((ApproximateHistogram)lhs).foldFast((ApproximateHistogram)rhs);
    }

    public ApproximateHistogramAggregator(String name, FloatColumnSelector selector, int resolution, float lowerLimit, float upperLimit) {
        this.name = name;
        this.selector = selector;
        this.resolution = resolution;
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.histogram = new ApproximateHistogram(resolution, lowerLimit, upperLimit);
    }

    public void aggregate() {
        this.histogram.offer(this.selector.get());
    }

    public void reset() {
        this.histogram = new ApproximateHistogram(this.resolution, this.lowerLimit, this.upperLimit);
    }

    public Object get() {
        return this.histogram;
    }

    public float getFloat() {
        throw new UnsupportedOperationException("ApproximateHistogramAggregator does not support getFloat()");
    }

    public long getLong() {
        throw new UnsupportedOperationException("ApproximateHistogramAggregator does not support getLong()");
    }

    public String getName() {
        return this.name;
    }

    public void close() {
    }
}

