/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.histogram.ApproximateHistogram;
import io.druid.segment.FloatColumnSelector;
import java.nio.ByteBuffer;

public class ApproximateHistogramBufferAggregator
implements BufferAggregator {
    private final FloatColumnSelector selector;
    private final int resolution;
    private final float lowerLimit;
    private final float upperLimit;

    public ApproximateHistogramBufferAggregator(FloatColumnSelector selector, int resolution, float lowerLimit, float upperLimit) {
        this.selector = selector;
        this.resolution = resolution;
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public void init(ByteBuffer buf, int position) {
        int i;
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        mutationBuffer.putInt(this.resolution);
        mutationBuffer.putInt(0);
        for (i = 0; i < this.resolution; ++i) {
            mutationBuffer.putFloat(0.0f);
        }
        for (i = 0; i < this.resolution; ++i) {
            mutationBuffer.putLong(0L);
        }
        mutationBuffer.putFloat(Float.POSITIVE_INFINITY);
        mutationBuffer.putFloat(Float.NEGATIVE_INFINITY);
    }

    public void aggregate(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        ApproximateHistogram h0 = ApproximateHistogram.fromBytesDense(mutationBuffer);
        h0.offer(this.selector.get());
        mutationBuffer.position(position);
        h0.toBytesDense(mutationBuffer);
    }

    public Object get(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        return ApproximateHistogram.fromBytes(mutationBuffer);
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("ApproximateHistogramBufferAggregator does not support getFloat()");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("ApproximateHistogramBufferAggregator does not support getLong()");
    }

    public void close() {
    }
}

