/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Sets;
import com.metamx.common.IAE;
import io.druid.query.aggregation.histogram.ApproximateHistogram;
import io.druid.query.aggregation.histogram.ApproximateHistogramPostAggregator;
import io.druid.query.aggregation.histogram.Quantiles;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

@JsonTypeName(value="quantiles")
public class QuantilesPostAggregator
extends ApproximateHistogramPostAggregator {
    private final float[] probabilities;
    private String fieldName;

    @JsonCreator
    public QuantilesPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="probabilities") float[] probabilities) {
        super(name, fieldName);
        this.probabilities = probabilities;
        this.fieldName = fieldName;
        for (float p : probabilities) {
            if (!(p < 0.0f | p > 1.0f)) continue;
            throw new IAE("Illegal probability[%s], must be strictly between 0 and 1", new Object[]{Float.valueOf(p)});
        }
    }

    @Override
    public Comparator getComparator() {
        throw new UnsupportedOperationException();
    }

    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Object compute(Map<String, Object> values) {
        ApproximateHistogram ah = (ApproximateHistogram)values.get(this.getFieldName());
        return new Quantiles(this.getProbabilities(), ah.getQuantiles(this.getProbabilities()), ah.getMin(), ah.getMax());
    }

    @JsonProperty
    public float[] getProbabilities() {
        return this.probabilities;
    }

    @Override
    public String toString() {
        return "EqualBucketsPostAggregator{name='" + this.getName() + '\'' + ", fieldName='" + this.getFieldName() + '\'' + ", probabilities=" + Arrays.toString(this.getProbabilities()) + '}';
    }
}

