/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.machinelearning.model.CreateMLModelRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class CreateMLModelRequestMarshaller
implements Marshaller<Request<CreateMLModelRequest>, CreateMLModelRequest> {
    public Request<CreateMLModelRequest> marshall(CreateMLModelRequest createMLModelRequest) {
        if (createMLModelRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createMLModelRequest, "AmazonMachineLearning");
        request.addHeader("X-Amz-Target", "AmazonML_20141212.CreateMLModel");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalMap parametersMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createMLModelRequest.getMLModelId() != null) {
                jsonWriter.key("MLModelId").value((Object)createMLModelRequest.getMLModelId());
            }
            if (createMLModelRequest.getMLModelName() != null) {
                jsonWriter.key("MLModelName").value((Object)createMLModelRequest.getMLModelName());
            }
            if (createMLModelRequest.getMLModelType() != null) {
                jsonWriter.key("MLModelType").value((Object)createMLModelRequest.getMLModelType());
            }
            if (!(parametersMap = (SdkInternalMap)createMLModelRequest.getParameters()).isEmpty() || !parametersMap.isAutoConstruct()) {
                jsonWriter.key("Parameters");
                jsonWriter.object();
                for (Map.Entry parametersMapValue : parametersMap.entrySet()) {
                    if (parametersMapValue.getValue() == null) continue;
                    jsonWriter.key((String)parametersMapValue.getKey());
                    jsonWriter.value(parametersMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (createMLModelRequest.getTrainingDataSourceId() != null) {
                jsonWriter.key("TrainingDataSourceId").value((Object)createMLModelRequest.getTrainingDataSourceId());
            }
            if (createMLModelRequest.getRecipe() != null) {
                jsonWriter.key("Recipe").value((Object)createMLModelRequest.getRecipe());
            }
            if (createMLModelRequest.getRecipeUri() != null) {
                jsonWriter.key("RecipeUri").value((Object)createMLModelRequest.getRecipeUri());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

