/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import io.druid.cli.Main;
import io.druid.guice.ExtensionsConfig;
import io.druid.initialization.Initialization;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Command(name="hadoop", description="Runs the batch Hadoop Druid Indexer, see http://druid.io/docs/latest/Batch-ingestion.html for a description.")
public class CliHadoopIndexer
implements Runnable {
    private static final String DEFAULT_HADOOP_COORDINATES = "org.apache.hadoop:hadoop-client:2.3.0";
    private static final Logger log = new Logger(CliHadoopIndexer.class);
    @Arguments(description="A JSON object or the path to a file that contains a JSON object", required=true)
    private String argumentSpec;
    @Option(name={"-c", "--coordinate", "hadoopDependencies"}, description="extra dependencies to pull down (e.g. non-default hadoop coordinates or extra hadoop jars)")
    private List<String> coordinates;
    @Option(name={"--no-default-hadoop"}, description="don't pull down the default hadoop version (currently org.apache.hadoop:hadoop-client:2.3.0)", required=false)
    public boolean noDefaultHadoop;
    @Inject
    private ExtensionsConfig extensionsConfig = null;

    @Override
    public void run() {
        try {
            ArrayList allCoordinates = Lists.newArrayList();
            if (this.coordinates != null) {
                allCoordinates.addAll(this.coordinates);
            }
            if (!this.noDefaultHadoop) {
                allCoordinates.add(DEFAULT_HADOOP_COORDINATES);
            }
            ArrayList extensionURLs = Lists.newArrayList();
            for (File extension : Initialization.getExtensionFilesToLoad((ExtensionsConfig)this.extensionsConfig)) {
                URLClassLoader extensionLoader = Initialization.getClassLoaderForExtension((File)extension);
                extensionURLs.addAll(Arrays.asList(extensionLoader.getURLs()));
            }
            ArrayList nonHadoopURLs = Lists.newArrayList();
            nonHadoopURLs.addAll(Arrays.asList(((URLClassLoader)CliHadoopIndexer.class.getClassLoader()).getURLs()));
            ArrayList driverURLs = Lists.newArrayList();
            driverURLs.addAll(nonHadoopURLs);
            for (File hadoopDependency : Initialization.getHadoopDependencyFilesToLoad((List)allCoordinates, (ExtensionsConfig)this.extensionsConfig)) {
                URLClassLoader hadoopLoader = Initialization.getClassLoaderForExtension((File)hadoopDependency);
                driverURLs.addAll(Arrays.asList(hadoopLoader.getURLs()));
            }
            URLClassLoader loader = new URLClassLoader(driverURLs.toArray(new URL[driverURLs.size()]), null);
            Thread.currentThread().setContextClassLoader(loader);
            ArrayList jobUrls = Lists.newArrayList();
            jobUrls.addAll(nonHadoopURLs);
            jobUrls.addAll(extensionURLs);
            System.setProperty("druid.hadoop.internal.classpath", Joiner.on((String)File.pathSeparator).join((Iterable)jobUrls));
            Class<?> mainClass = loader.loadClass(Main.class.getName());
            Method mainMethod = mainClass.getMethod("main", String[].class);
            String[] args = new String[]{"internal", "hadoop-indexer", this.argumentSpec};
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            log.error((Throwable)e, "failure!!!!", new Object[0]);
            System.exit(1);
        }
    }
}

