/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.metamx.common.logger.Logger;
import io.airlift.airline.Command;
import io.druid.cli.QueryJettyServerInitializer;
import io.druid.cli.ServerRunnable;
import io.druid.client.cache.CacheConfig;
import io.druid.client.cache.CacheMonitor;
import io.druid.guice.CacheModule;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.NodeTypeConfig;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.lookup.LookupModule;
import io.druid.server.QueryResource;
import io.druid.server.coordination.ServerManager;
import io.druid.server.coordination.ZkCoordinator;
import io.druid.server.http.HistoricalResource;
import io.druid.server.initialization.jetty.JettyServerInitializer;
import io.druid.server.metrics.MetricsModule;
import java.lang.annotation.Annotation;
import java.util.List;
import org.eclipse.jetty.server.Server;

@Command(name="historical", description="Runs a Historical node, see http://druid.io/docs/latest/Historical.html for a description")
public class CliHistorical
extends ServerRunnable {
    private static final Logger log = new Logger(CliHistorical.class);

    public CliHistorical() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/historical");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8083);
                LifecycleModule.register((Binder)binder, Server.class);
                binder.bind(ServerManager.class).in(LazySingleton.class);
                binder.bind(ZkCoordinator.class).in(ManageLifecycle.class);
                binder.bind(QuerySegmentWalker.class).to(ServerManager.class).in(LazySingleton.class);
                binder.bind(NodeTypeConfig.class).toInstance((Object)new NodeTypeConfig("historical"));
                binder.bind(JettyServerInitializer.class).to(QueryJettyServerInitializer.class).in(LazySingleton.class);
                Jerseys.addResource((Binder)binder, QueryResource.class);
                Jerseys.addResource((Binder)binder, HistoricalResource.class);
                LifecycleModule.register((Binder)binder, QueryResource.class);
                LifecycleModule.register((Binder)binder, ZkCoordinator.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.historical.cache", CacheConfig.class);
                binder.install((Module)new CacheModule());
                MetricsModule.register((Binder)binder, CacheMonitor.class);
            }
        }, (Object)new LookupModule());
    }
}

