/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.metamx.common.logger.Logger;
import io.airlift.airline.Command;
import io.druid.cli.ServerRunnable;
import io.druid.guice.RealtimeModule;
import io.druid.query.lookup.LookupModule;
import io.druid.server.initialization.jetty.ChatHandlerServerModule;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Properties;

@Command(name="realtime", description="Runs a realtime node, see http://druid.io/docs/latest/Realtime.html for a description")
public class CliRealtime
extends ServerRunnable {
    private static final Logger log = new Logger(CliRealtime.class);
    @Inject
    private Properties properties;

    public CliRealtime() {
        super(log);
    }

    @Override
    protected List<? extends Module> getModules() {
        return ImmutableList.of((Object)new RealtimeModule(), (Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/realtime");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(8084);
            }
        }, (Object)new ChatHandlerServerModule(this.properties), (Object)new LookupModule());
    }
}

