/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.base.Throwables;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.common.logger.Logger;
import io.druid.initialization.Initialization;
import io.druid.initialization.LogLevelAdjuster;
import io.druid.server.log.StartupLoggingConfig;
import java.util.List;
import java.util.Properties;

public abstract class GuiceRunnable
implements Runnable {
    private final Logger log;
    private Injector baseInjector;

    public GuiceRunnable(Logger log) {
        this.log = log;
    }

    @Inject
    public void configure(Injector injector) {
        this.baseInjector = injector;
    }

    protected abstract List<? extends Module> getModules();

    public Injector makeInjector() {
        try {
            return Initialization.makeInjectorWithModules((Injector)this.baseInjector, this.getModules());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Lifecycle initLifecycle(Injector injector) {
        try {
            LogLevelAdjuster.register();
            Lifecycle lifecycle = (Lifecycle)injector.getInstance(Lifecycle.class);
            StartupLoggingConfig startupLoggingConfig = (StartupLoggingConfig)injector.getInstance(StartupLoggingConfig.class);
            this.log.info("Starting up with processors[%,d], memory[%,d].", new Object[]{Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().totalMemory()});
            if (startupLoggingConfig.isLogProperties()) {
                Properties props = (Properties)injector.getInstance(Properties.class);
                for (String propertyName : Ordering.natural().sortedCopy(props.stringPropertyNames())) {
                    this.log.info("* %s: %s", new Object[]{propertyName, props.getProperty(propertyName)});
                }
            }
            try {
                lifecycle.start();
            }
            catch (Throwable t) {
                this.log.error(t, "Error when starting up.  Failing.", new Object[0]);
                System.exit(1);
            }
            return lifecycle;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

