/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.servlet.GuiceFilter;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Smile;
import io.druid.guice.http.DruidHttpClientConfig;
import io.druid.server.AsyncQueryForwardingServlet;
import io.druid.server.initialization.jetty.JettyServerInitUtils;
import io.druid.server.initialization.jetty.JettyServerInitializer;
import io.druid.server.log.RequestLogger;
import io.druid.server.router.QueryHostFinder;
import io.druid.server.router.Router;
import javax.servlet.Servlet;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class RouterJettyServerInitializer
implements JettyServerInitializer {
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private final QueryHostFinder hostFinder;
    private final Provider<HttpClient> httpClientProvider;
    private final DruidHttpClientConfig httpClientConfig;
    private final ServiceEmitter emitter;
    private final RequestLogger requestLogger;

    @Inject
    public RouterJettyServerInitializer(@Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, QueryHostFinder hostFinder, @Router Provider<HttpClient> httpClientProvider, DruidHttpClientConfig httpClientConfig, ServiceEmitter emitter, RequestLogger requestLogger) {
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.hostFinder = hostFinder;
        this.httpClientProvider = httpClientProvider;
        this.httpClientConfig = httpClientConfig;
        this.emitter = emitter;
        this.requestLogger = requestLogger;
    }

    public void initialize(Server server, Injector injector) {
        ServletContextHandler root = new ServletContextHandler(1);
        root.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
        AsyncQueryForwardingServlet asyncQueryForwardingServlet = new AsyncQueryForwardingServlet(this.jsonMapper, this.smileMapper, this.hostFinder, this.httpClientProvider, this.httpClientConfig, this.emitter, this.requestLogger);
        asyncQueryForwardingServlet.setTimeout(this.httpClientConfig.getReadTimeout().getMillis());
        ServletHolder sh = new ServletHolder((Servlet)asyncQueryForwardingServlet);
        sh.setInitParameter("maxThreads", Integer.toString(this.httpClientConfig.getNumMaxThreads()));
        root.addServlet(sh, "/druid/v2/*");
        JettyServerInitUtils.addExtensionFilters((ServletContextHandler)root, (Injector)injector);
        root.addFilter(JettyServerInitUtils.defaultAsyncGzipFilterHolder(), "/*", null);
        root.addFilter(GuiceFilter.class, "/status/*", null);
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers(new Handler[]{JettyServerInitUtils.getJettyRequestLogHandler(), root});
        server.setHandler((Handler)handlerList);
    }
}

