/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli.convert;

import com.google.common.collect.ImmutableMap;
import io.druid.cli.convert.PropertyConverter;
import java.util.Map;
import java.util.Properties;

public class ValueConverter
implements PropertyConverter {
    private final Map<String, String> valueMap;
    private final String property;

    public ValueConverter(String property, Map<String, String> valueMap) {
        this.property = property;
        this.valueMap = valueMap;
    }

    @Override
    public boolean canHandle(String property) {
        return this.property.equals(property);
    }

    @Override
    public Map<String, String> convert(Properties properties) {
        String oldValue = properties.getProperty(this.property);
        if (null == oldValue) {
            return ImmutableMap.of();
        }
        String newValue = this.valueMap.get(oldValue);
        if (null == newValue) {
            return ImmutableMap.of();
        }
        return ImmutableMap.of((Object)this.property, (Object)newValue);
    }
}

