/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import io.druid.cli.QueryJettyServerInitializer;
import io.druid.client.cache.CacheConfig;
import io.druid.client.coordinator.CoordinatorClient;
import io.druid.guice.CacheModule;
import io.druid.guice.FireDepartmentsProvider;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.NodeTypeConfig;
import io.druid.guice.PolyBind;
import io.druid.guice.RealtimeManagerConfig;
import io.druid.metadata.MetadataSegmentPublisher;
import io.druid.query.QuerySegmentWalker;
import io.druid.segment.realtime.FireDepartment;
import io.druid.segment.realtime.NoopSegmentPublisher;
import io.druid.segment.realtime.RealtimeManager;
import io.druid.segment.realtime.SegmentPublisher;
import io.druid.segment.realtime.firehose.ChatHandlerProvider;
import io.druid.segment.realtime.firehose.NoopChatHandlerProvider;
import io.druid.segment.realtime.firehose.ServiceAnnouncingChatHandlerProvider;
import io.druid.segment.realtime.plumber.CoordinatorBasedSegmentHandoffNotifierConfig;
import io.druid.segment.realtime.plumber.CoordinatorBasedSegmentHandoffNotifierFactory;
import io.druid.segment.realtime.plumber.SegmentHandoffNotifierFactory;
import io.druid.server.QueryResource;
import io.druid.server.initialization.jetty.JettyServerInitializer;
import java.util.List;
import org.eclipse.jetty.server.Server;

public class RealtimeModule
implements Module {
    public void configure(Binder binder) {
        PolyBind.createChoiceWithDefault((Binder)binder, (String)"druid.publish.type", (Key)Key.get(SegmentPublisher.class), null, (String)"metadata");
        MapBinder publisherBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(SegmentPublisher.class));
        publisherBinder.addBinding((Object)"noop").to(NoopSegmentPublisher.class).in(LazySingleton.class);
        publisherBinder.addBinding((Object)"metadata").to(MetadataSegmentPublisher.class).in(LazySingleton.class);
        PolyBind.createChoice((Binder)binder, (String)"druid.realtime.chathandler.type", (Key)Key.get(ChatHandlerProvider.class), (Key)Key.get(ServiceAnnouncingChatHandlerProvider.class));
        MapBinder handlerProviderBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(ChatHandlerProvider.class));
        handlerProviderBinder.addBinding((Object)"announce").to(ServiceAnnouncingChatHandlerProvider.class).in(LazySingleton.class);
        handlerProviderBinder.addBinding((Object)"noop").to(NoopChatHandlerProvider.class).in(LazySingleton.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.realtime", RealtimeManagerConfig.class);
        binder.bind((TypeLiteral)new TypeLiteral<List<FireDepartment>>(){}).toProvider(FireDepartmentsProvider.class).in(LazySingleton.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.segment.handoff", CoordinatorBasedSegmentHandoffNotifierConfig.class);
        binder.bind(SegmentHandoffNotifierFactory.class).to(CoordinatorBasedSegmentHandoffNotifierFactory.class).in(LazySingleton.class);
        binder.bind(CoordinatorClient.class).in(LazySingleton.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.realtime.cache", CacheConfig.class);
        binder.install((Module)new CacheModule());
        binder.bind(QuerySegmentWalker.class).to(RealtimeManager.class).in(ManageLifecycle.class);
        binder.bind(NodeTypeConfig.class).toInstance((Object)new NodeTypeConfig("realtime"));
        binder.bind(JettyServerInitializer.class).to(QueryJettyServerInitializer.class).in(LazySingleton.class);
        Jerseys.addResource((Binder)binder, QueryResource.class);
        LifecycleModule.register((Binder)binder, QueryResource.class);
        LifecycleModule.register((Binder)binder, Server.class);
    }
}

