/*
 * Decompiled with CFR 0.152.
 */
package io.druid.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.metadata.PasswordProvider;

public class MetadataStorageConnectorConfig {
    @JsonProperty
    private boolean createTables = true;
    @JsonProperty
    private String host = "localhost";
    @JsonProperty
    private int port = 1527;
    @JsonProperty
    private String connectURI;
    @JsonProperty
    private String user = null;
    @JsonProperty(value="password")
    private PasswordProvider passwordProvider;

    public boolean isCreateTables() {
        return this.createTables;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getConnectURI() {
        if (this.connectURI == null) {
            return String.format("jdbc:derby://%s:%s/druid;create=true", this.host, this.port);
        }
        return this.connectURI;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.passwordProvider == null ? null : this.passwordProvider.getPassword();
    }

    public String toString() {
        return "DbConnectorConfig{createTables=" + this.createTables + ", connectURI='" + this.getConnectURI() + '\'' + ", user='" + this.user + '\'' + ", passwordProvider=" + this.passwordProvider + '}';
    }
}

