/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input;

import com.google.common.base.Charsets;
import com.google.common.io.ByteSource;
import com.google.common.io.LineProcessor;
import com.metamx.common.parsers.Parser;
import java.io.IOException;
import java.util.Map;

public class MapPopulator<K, V> {
    private final Parser<K, V> parser;

    public MapPopulator(Parser<K, V> parser) {
        this.parser = parser;
    }

    public long populate(ByteSource source, final Map<K, V> map) throws IOException {
        return (Long)source.asCharSource(Charsets.UTF_8).readLines((LineProcessor)new LineProcessor<Long>(){
            private long count = 0L;

            public boolean processLine(String line) throws IOException {
                map.putAll(MapPopulator.this.parser.parse(line));
                ++this.count;
                return true;
            }

            public Long getResult() {
                return this.count;
            }
        });
    }
}

