/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.lookup;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.metamx.common.ISE;
import com.metamx.common.StringUtils;
import com.metamx.common.logger.Logger;
import io.druid.common.utils.ServletResourceUtils;
import io.druid.query.extraction.MapLookupExtractor;
import io.druid.query.lookup.LookupExtractor;
import io.druid.query.lookup.LookupExtractorFactory;
import io.druid.query.lookup.LookupIntrospectHandler;
import io.druid.query.lookup.namespace.ExtractionNamespace;
import io.druid.server.lookup.namespace.cache.NamespaceExtractionCacheManager;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@JsonTypeName(value="cachedNamespace")
public class NamespaceLookupExtractorFactory
implements LookupExtractorFactory {
    private static final Logger LOG = new Logger(NamespaceLookupExtractorFactory.class);
    private static final byte[] CLASS_CACHE_KEY;
    private volatile boolean started = false;
    private final ReadWriteLock startStopSync = new ReentrantReadWriteLock();
    private final NamespaceExtractionCacheManager manager;
    private final LookupIntrospectHandler lookupIntrospectHandler;
    private final ExtractionNamespace extractionNamespace;
    private final long firstCacheTimeout;
    private final boolean injective;
    private final String extractorID;

    @JsonCreator
    public NamespaceLookupExtractorFactory(@JsonProperty(value="extractionNamespace") ExtractionNamespace extractionNamespace, @JsonProperty(value="firstCacheTimeout") long firstCacheTimeout, @JsonProperty(value="injective") boolean injective, final @JacksonInject NamespaceExtractionCacheManager manager) {
        this.extractionNamespace = (ExtractionNamespace)Preconditions.checkNotNull((Object)extractionNamespace, (Object)"extractionNamespace should be specified");
        this.firstCacheTimeout = firstCacheTimeout;
        Preconditions.checkArgument((this.firstCacheTimeout >= 0L ? 1 : 0) != 0);
        this.injective = injective;
        this.manager = manager;
        this.extractorID = this.buildID();
        this.lookupIntrospectHandler = new LookupIntrospectHandler(){

            @GET
            @Path(value="/keys")
            @Produces(value={"application/json"})
            public Response getKeys() {
                try {
                    return Response.ok(this.getLatest().keySet()).build();
                }
                catch (ISE e) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
                }
            }

            @GET
            @Path(value="/values")
            @Produces(value={"application/json"})
            public Response getValues() {
                try {
                    return Response.ok(this.getLatest().values()).build();
                }
                catch (ISE e) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
                }
            }

            @GET
            @Path(value="/version")
            @Produces(value={"application/json"})
            public Response getVersion() {
                String version = manager.getVersion(NamespaceLookupExtractorFactory.this.extractorID);
                if (null == version) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                return Response.ok((Object)ImmutableMap.of((Object)"version", (Object)version)).build();
            }

            @GET
            @Produces(value={"application/json"})
            public Response getMap() {
                try {
                    return Response.ok(this.getLatest()).build();
                }
                catch (ISE e) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
                }
            }

            private Map<String, String> getLatest() {
                return ((MapLookupExtractor)NamespaceLookupExtractorFactory.this.get()).getMap();
            }
        };
    }

    @VisibleForTesting
    public NamespaceLookupExtractorFactory(ExtractionNamespace extractionNamespace, NamespaceExtractionCacheManager manager) {
        this(extractionNamespace, 60000L, false, manager);
    }

    public boolean start() {
        Lock writeLock = this.startStopSync.writeLock();
        writeLock.lock();
        try {
            if (this.started) {
                LOG.warn("Already started! [%s]", new Object[]{this.extractorID});
                boolean bl = true;
                return bl;
            }
            if (this.firstCacheTimeout > 0L) {
                if (!this.manager.scheduleAndWait(this.extractorID, this.extractionNamespace, this.firstCacheTimeout)) {
                    LOG.error("Failed to schedule and wait for lookup [%s]", new Object[]{this.extractorID});
                    boolean bl = false;
                    return bl;
                }
            } else if (!this.manager.scheduleOrUpdate(this.extractorID, this.extractionNamespace)) {
                LOG.error("Failed to schedule lookup [%s]", new Object[]{this.extractorID});
                boolean bl = false;
                return bl;
            }
            LOG.debug("NamespaceLookupExtractorFactory[%s] started", new Object[]{this.extractorID});
            this.started = true;
            boolean bl = true;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean close() {
        Lock writeLock = this.startStopSync.writeLock();
        writeLock.lock();
        try {
            if (!this.started) {
                LOG.warn("Not started! [%s]", new Object[]{this.extractorID});
                boolean bl = true;
                return bl;
            }
            this.started = false;
            boolean bl = this.manager.checkedDelete(this.extractorID);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean replaces(@Nullable LookupExtractorFactory other) {
        if (other != null && other instanceof NamespaceLookupExtractorFactory) {
            NamespaceLookupExtractorFactory that = (NamespaceLookupExtractorFactory)other;
            if (this.isInjective() != ((NamespaceLookupExtractorFactory)other).isInjective()) {
                return true;
            }
            if (this.getFirstCacheTimeout() != ((NamespaceLookupExtractorFactory)other).getFirstCacheTimeout()) {
                return true;
            }
            return !this.extractionNamespace.equals(that.extractionNamespace);
        }
        return true;
    }

    public LookupIntrospectHandler getIntrospectHandler() {
        return this.lookupIntrospectHandler;
    }

    @JsonProperty
    public ExtractionNamespace getExtractionNamespace() {
        return this.extractionNamespace;
    }

    @JsonProperty
    public long getFirstCacheTimeout() {
        return this.firstCacheTimeout;
    }

    @JsonProperty
    public boolean isInjective() {
        return this.injective;
    }

    private String buildID() {
        return UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LookupExtractor get() {
        Lock readLock = this.startStopSync.readLock();
        readLock.lock();
        try {
            if (!this.started) {
                throw new ISE("Factory [%s] not started", new Object[]{this.extractorID});
            }
            String preVersion = null;
            String postVersion = null;
            ConcurrentMap<String, String> map = null;
            do {
                if ((preVersion = this.manager.getVersion(this.extractorID)) == null) {
                    throw new ISE("Namespace vanished for [%s]", new Object[]{this.extractorID});
                }
                map = this.manager.getCacheMap(this.extractorID);
                postVersion = this.manager.getVersion(this.extractorID);
                if (postVersion != null) continue;
                this.manager.delete(this.extractorID);
                throw new ISE("Lookup [%s] is deleting", new Object[]{this.extractorID});
            } while (!preVersion.equals(postVersion));
            final byte[] v = StringUtils.toUtf8((String)postVersion);
            final byte[] id = StringUtils.toUtf8((String)this.extractorID);
            MapLookupExtractor mapLookupExtractor = new MapLookupExtractor(map, this.isInjective()){

                public byte[] getCacheKey() {
                    return ByteBuffer.allocate(CLASS_CACHE_KEY.length + id.length + 1 + v.length + 1 + 1).put(CLASS_CACHE_KEY).put(id).put((byte)-1).put(v).put((byte)-1).put(this.isOneToOne() ? (byte)1 : 0).array();
                }
            };
            return mapLookupExtractor;
        }
        finally {
            readLock.unlock();
        }
    }

    static {
        byte[] keyUtf8 = StringUtils.toUtf8((String)NamespaceLookupExtractorFactory.class.getCanonicalName());
        CLASS_CACHE_KEY = ByteBuffer.allocate(keyUtf8.length + 1).put(keyUtf8).put((byte)-1).array();
    }
}

