/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.lookup.namespace;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.metamx.common.IAE;
import com.metamx.common.UOE;
import com.metamx.common.parsers.CSVParser;
import com.metamx.common.parsers.DelimitedParser;
import com.metamx.common.parsers.JSONParser;
import com.metamx.common.parsers.Parser;
import io.druid.guice.annotations.Json;
import io.druid.query.lookup.namespace.ExtractionNamespace;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.joda.time.Period;

@JsonTypeName(value="uri")
public class URIExtractionNamespace
implements ExtractionNamespace {
    @JsonProperty
    private final URI uri;
    @JsonProperty
    private final URI uriPrefix;
    @JsonProperty
    private final FlatDataParser namespaceParseSpec;
    @JsonProperty
    private final String fileRegex;
    @JsonProperty
    private final Period pollPeriod;

    @JsonCreator
    public URIExtractionNamespace(@JsonProperty(value="uri", required=false) URI uri, @JsonProperty(value="uriPrefix", required=false) URI uriPrefix, @JsonProperty(value="fileRegex", required=false) String fileRegex, @JsonProperty(value="namespaceParseSpec", required=true) FlatDataParser namespaceParseSpec, @Min(value=0L) @Nullable @JsonProperty(value="pollPeriod", required=false) Period pollPeriod, @Deprecated @JsonProperty(value="versionRegex", required=false) String versionRegex) {
        this.uri = uri;
        this.uriPrefix = uriPrefix;
        if (uri != null == (uriPrefix != null)) {
            throw new IAE("Either uri xor uriPrefix required", new Object[0]);
        }
        this.namespaceParseSpec = (FlatDataParser)Preconditions.checkNotNull((Object)namespaceParseSpec, (Object)"namespaceParseSpec");
        this.pollPeriod = pollPeriod == null ? Period.ZERO : pollPeriod;
        String string = this.fileRegex = fileRegex == null ? versionRegex : fileRegex;
        if (fileRegex != null && versionRegex != null) {
            throw new IAE("Cannot specify both versionRegex and fileRegex. versionRegex is deprecated", new Object[0]);
        }
        if (uri != null && this.fileRegex != null) {
            throw new IAE("Cannot define both uri and fileRegex", new Object[0]);
        }
        if (this.fileRegex != null) {
            try {
                Pattern.compile(this.fileRegex);
            }
            catch (PatternSyntaxException ex) {
                throw new IAE((Throwable)ex, "Could not parse `fileRegex` [%s]", new Object[]{this.fileRegex});
            }
        }
    }

    public String getFileRegex() {
        return this.fileRegex;
    }

    public FlatDataParser getNamespaceParseSpec() {
        return this.namespaceParseSpec;
    }

    public URI getUri() {
        return this.uri;
    }

    public URI getUriPrefix() {
        return this.uriPrefix;
    }

    @Override
    public long getPollMs() {
        return this.pollPeriod.toStandardDuration().getMillis();
    }

    public String toString() {
        return "URIExtractionNamespace{uri=" + this.uri + ", uriPrefix=" + this.uriPrefix + ", namespaceParseSpec=" + this.namespaceParseSpec + ", fileRegex='" + this.fileRegex + '\'' + ", pollPeriod=" + this.pollPeriod + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URIExtractionNamespace that = (URIExtractionNamespace)o;
        if (this.getUri() != null ? !this.getUri().equals(that.getUri()) : that.getUri() != null) {
            return false;
        }
        if (this.getUriPrefix() != null ? !this.getUriPrefix().equals(that.getUriPrefix()) : that.getUriPrefix() != null) {
            return false;
        }
        if (!this.getNamespaceParseSpec().equals(that.getNamespaceParseSpec())) {
            return false;
        }
        if (this.getFileRegex() != null ? !this.getFileRegex().equals(that.getFileRegex()) : that.getFileRegex() != null) {
            return false;
        }
        return this.pollPeriod.equals((Object)that.pollPeriod);
    }

    public int hashCode() {
        int result = this.getUri() != null ? this.getUri().hashCode() : 0;
        result = 31 * result + (this.getUriPrefix() != null ? this.getUriPrefix().hashCode() : 0);
        result = 31 * result + this.getNamespaceParseSpec().hashCode();
        result = 31 * result + (this.getFileRegex() != null ? this.getFileRegex().hashCode() : 0);
        result = 31 * result + this.pollPeriod.hashCode();
        return result;
    }

    @JsonTypeName(value="simpleJson")
    public static class ObjectMapperFlatDataParser
    implements FlatDataParser {
        private final Parser<String, String> parser;

        @JsonCreator
        public ObjectMapperFlatDataParser(final @JacksonInject @Json ObjectMapper jsonMapper) {
            this.parser = new Parser<String, String>(){

                public Map<String, String> parse(String input) {
                    try {
                        return (Map)jsonMapper.readValue(input, (TypeReference)new TypeReference<Map<String, String>>(){});
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }

                public void setFieldNames(Iterable<String> fieldNames) {
                    throw new UOE("No field names available", new Object[0]);
                }

                public List<String> getFieldNames() {
                    throw new UOE("No field names available", new Object[0]);
                }
            };
        }

        @Override
        public Parser<String, String> getParser() {
            return this.parser;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public String toString() {
            return "ObjectMapperFlatDataParser = { }";
        }
    }

    @JsonTypeName(value="customJson")
    public static class JSONFlatDataParser
    implements FlatDataParser {
        private final Parser<String, String> parser;
        private final String keyFieldName;
        private final String valueFieldName;

        @JsonCreator
        public JSONFlatDataParser(@JacksonInject @Json ObjectMapper jsonMapper, @JsonProperty(value="keyFieldName") String keyFieldName, @JsonProperty(value="valueFieldName") String valueFieldName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)keyFieldName) ? 1 : 0) != 0, (Object)"[keyFieldName] cannot be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)valueFieldName) ? 1 : 0) != 0, (Object)"[valueFieldName] cannot be empty");
            this.keyFieldName = keyFieldName;
            this.valueFieldName = valueFieldName;
            this.parser = new DelegateParser((Parser)new JSONParser(jsonMapper, (Iterable)ImmutableList.of((Object)keyFieldName, (Object)valueFieldName)), keyFieldName, valueFieldName);
        }

        @JsonProperty
        public String getKeyFieldName() {
            return this.keyFieldName;
        }

        @JsonProperty
        public String getValueFieldName() {
            return this.valueFieldName;
        }

        @Override
        public Parser<String, String> getParser() {
            return this.parser;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JSONFlatDataParser that = (JSONFlatDataParser)o;
            if (!this.getKeyFieldName().equals(that.getKeyFieldName())) {
                return false;
            }
            return this.getValueFieldName().equals(that.getValueFieldName());
        }

        public String toString() {
            return String.format("JSONFlatDataParser = { keyFieldName = %s, valueFieldName = %s }", this.keyFieldName, this.valueFieldName);
        }
    }

    @JsonTypeName(value="tsv")
    public static class TSVFlatDataParser
    implements FlatDataParser {
        private final Parser<String, String> parser;
        private final List<String> columns;
        private final String delimiter;
        private final String listDelimiter;
        private final String keyColumn;
        private final String valueColumn;

        @JsonCreator
        public TSVFlatDataParser(@JsonProperty(value="columns") List<String> columns, @JsonProperty(value="delimiter") String delimiter, @JsonProperty(value="listDelimiter") String listDelimiter, @JsonProperty(value="keyColumn") String keyColumn, @JsonProperty(value="valueColumn") String valueColumn) {
            Preconditions.checkArgument((((List)Preconditions.checkNotNull(columns, (Object)"`columns` list required")).size() > 1 ? 1 : 0) != 0, (Object)"Must specify more than one column to have a key value pair");
            DelimitedParser delegate = new DelimitedParser(Optional.fromNullable((Object)Strings.emptyToNull((String)delimiter)), Optional.fromNullable((Object)Strings.emptyToNull((String)listDelimiter)));
            Preconditions.checkArgument((!(Strings.isNullOrEmpty((String)keyColumn) ^ Strings.isNullOrEmpty((String)valueColumn)) ? 1 : 0) != 0, (Object)"Must specify both `keyColumn` and `valueColumn` or neither `keyColumn` nor `valueColumn`");
            delegate.setFieldNames(columns);
            this.columns = columns;
            this.delimiter = delimiter;
            this.listDelimiter = listDelimiter;
            this.keyColumn = Strings.isNullOrEmpty((String)keyColumn) ? columns.get(0) : keyColumn;
            this.valueColumn = Strings.isNullOrEmpty((String)valueColumn) ? columns.get(1) : valueColumn;
            Preconditions.checkArgument((boolean)columns.contains(this.keyColumn), (String)"Column [%s] not found int columns: %s", (Object[])new Object[]{this.keyColumn, Arrays.toString(columns.toArray())});
            Preconditions.checkArgument((boolean)columns.contains(this.valueColumn), (String)"Column [%s] not found int columns: %s", (Object[])new Object[]{this.valueColumn, Arrays.toString(columns.toArray())});
            this.parser = new DelegateParser((Parser)delegate, this.keyColumn, this.valueColumn);
        }

        @JsonProperty
        public List<String> getColumns() {
            return this.columns;
        }

        @JsonProperty
        public String getKeyColumn() {
            return this.keyColumn;
        }

        @JsonProperty
        public String getValueColumn() {
            return this.valueColumn;
        }

        @JsonProperty
        public String getListDelimiter() {
            return this.listDelimiter;
        }

        @JsonProperty
        public String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public Parser<String, String> getParser() {
            return this.parser;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TSVFlatDataParser that = (TSVFlatDataParser)o;
            if (!this.getColumns().equals(that.getColumns())) {
                return false;
            }
            if (this.getDelimiter() == null ? that.getDelimiter() == null : this.getDelimiter().equals(that.getDelimiter())) {
                return false;
            }
            if (!this.getKeyColumn().equals(that.getKeyColumn())) {
                return false;
            }
            return this.getValueColumn().equals(that.getValueColumn());
        }

        public String toString() {
            return String.format("TSVFlatDataParser = { columns = %s, delimiter = '%s', listDelimiter = '%s',keyColumn = %s, valueColumn = %s }", Arrays.toString(this.columns.toArray()), this.delimiter, this.listDelimiter, this.keyColumn, this.valueColumn);
        }
    }

    @JsonTypeName(value="csv")
    public static class CSVFlatDataParser
    implements FlatDataParser {
        private final Parser<String, String> parser;
        private final List<String> columns;
        private final String keyColumn;
        private final String valueColumn;

        @JsonCreator
        public CSVFlatDataParser(@JsonProperty(value="columns") List<String> columns, @JsonProperty(value="keyColumn") String keyColumn, @JsonProperty(value="valueColumn") String valueColumn) {
            Preconditions.checkArgument((((List)Preconditions.checkNotNull(columns, (Object)"`columns` list required")).size() > 1 ? 1 : 0) != 0, (Object)"Must specify more than one column to have a key value pair");
            Preconditions.checkArgument((!(Strings.isNullOrEmpty((String)keyColumn) ^ Strings.isNullOrEmpty((String)valueColumn)) ? 1 : 0) != 0, (Object)"Must specify both `keyColumn` and `valueColumn` or neither `keyColumn` nor `valueColumn`");
            this.columns = columns;
            this.keyColumn = Strings.isNullOrEmpty((String)keyColumn) ? columns.get(0) : keyColumn;
            this.valueColumn = Strings.isNullOrEmpty((String)valueColumn) ? columns.get(1) : valueColumn;
            Preconditions.checkArgument((boolean)columns.contains(this.keyColumn), (String)"Column [%s] not found int columns: %s", (Object[])new Object[]{this.keyColumn, Arrays.toString(columns.toArray())});
            Preconditions.checkArgument((boolean)columns.contains(this.valueColumn), (String)"Column [%s] not found int columns: %s", (Object[])new Object[]{this.valueColumn, Arrays.toString(columns.toArray())});
            this.parser = new DelegateParser((Parser)new CSVParser(Optional.absent(), columns), this.keyColumn, this.valueColumn);
        }

        @JsonProperty
        public List<String> getColumns() {
            return this.columns;
        }

        @JsonProperty
        public String getKeyColumn() {
            return this.keyColumn;
        }

        @JsonProperty
        public String getValueColumn() {
            return this.valueColumn;
        }

        @Override
        public Parser<String, String> getParser() {
            return this.parser;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CSVFlatDataParser that = (CSVFlatDataParser)o;
            if (!this.getColumns().equals(that.getColumns())) {
                return false;
            }
            if (!this.getKeyColumn().equals(that.getKeyColumn())) {
                return false;
            }
            return this.getValueColumn().equals(that.getValueColumn());
        }

        public String toString() {
            return String.format("CSVFlatDataParser = { columns = %s, keyColumn = %s, valueColumn = %s }", Arrays.toString(this.columns.toArray()), this.keyColumn, this.valueColumn);
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="format")
    @JsonSubTypes(value={@JsonSubTypes.Type(name="csv", value=CSVFlatDataParser.class), @JsonSubTypes.Type(name="tsv", value=TSVFlatDataParser.class), @JsonSubTypes.Type(name="customJson", value=JSONFlatDataParser.class), @JsonSubTypes.Type(name="simpleJson", value=ObjectMapperFlatDataParser.class)})
    public static interface FlatDataParser {
        public Parser<String, String> getParser();
    }

    private static class DelegateParser
    implements Parser<String, String> {
        private final Parser<String, Object> delegate;
        private final String key;
        private final String value;

        private DelegateParser(Parser<String, Object> delegate, @NotNull String key, @NotNull String value) {
            this.delegate = delegate;
            this.key = key;
            this.value = value;
        }

        public Map<String, String> parse(String input) {
            Map inner = this.delegate.parse(input);
            String k = Preconditions.checkNotNull(inner.get(this.key), (String)"Key column [%s] missing data in line [%s]", (Object[])new Object[]{this.key, input}).toString();
            String val = Preconditions.checkNotNull(inner.get(this.value), (String)"Value column [%s] missing data in line [%s]", (Object[])new Object[]{this.value, input}).toString();
            return ImmutableMap.of((Object)k, (Object)val);
        }

        public void setFieldNames(Iterable<String> fieldNames) {
            this.delegate.setFieldNames(fieldNames);
        }

        public List<String> getFieldNames() {
            return this.delegate.getFieldNames();
        }
    }
}

