/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.lookup.namespace;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.io.ByteSource;
import com.google.inject.Inject;
import com.metamx.common.CompressionUtils;
import com.metamx.common.IAE;
import com.metamx.common.RetryUtils;
import com.metamx.common.logger.Logger;
import io.druid.data.SearchableVersionedDataFinder;
import io.druid.data.input.MapPopulator;
import io.druid.query.lookup.namespace.ExtractionNamespaceCacheFactory;
import io.druid.query.lookup.namespace.URIExtractionNamespace;
import io.druid.segment.loading.URIDataPuller;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class URIExtractionNamespaceCacheFactory
implements ExtractionNamespaceCacheFactory<URIExtractionNamespace> {
    private static final int DEFAULT_NUM_RETRIES = 3;
    private static final Logger log = new Logger(URIExtractionNamespaceCacheFactory.class);
    private final Map<String, SearchableVersionedDataFinder> pullers;

    @Inject
    public URIExtractionNamespaceCacheFactory(Map<String, SearchableVersionedDataFinder> pullers) {
        this.pullers = pullers;
    }

    @Override
    public Callable<String> getCachePopulator(final String id, final URIExtractionNamespace extractionNamespace, String lastVersion, final Map<String, String> cache) {
        final long lastCached = lastVersion == null ? -4611686018427387904L : Long.parseLong(lastVersion);
        return new Callable<String>(){

            @Override
            public String call() {
                URI uri;
                boolean doSearch = extractionNamespace.getUriPrefix() != null;
                URI originalUri = doSearch ? extractionNamespace.getUriPrefix() : extractionNamespace.getUri();
                SearchableVersionedDataFinder pullerRaw = (SearchableVersionedDataFinder)URIExtractionNamespaceCacheFactory.this.pullers.get(originalUri.getScheme());
                if (pullerRaw == null) {
                    throw new IAE("Unknown loader type[%s].  Known types are %s", new Object[]{originalUri.getScheme(), URIExtractionNamespaceCacheFactory.this.pullers.keySet()});
                }
                if (!(pullerRaw instanceof URIDataPuller)) {
                    throw new IAE("Cannot load data from location [%s]. Data pulling from [%s] not supported", new Object[]{originalUri, originalUri.getScheme()});
                }
                final URIDataPuller puller = (URIDataPuller)pullerRaw;
                if (doSearch) {
                    Pattern versionRegex = extractionNamespace.getFileRegex() != null ? Pattern.compile(extractionNamespace.getFileRegex()) : null;
                    uri = (URI)pullerRaw.getLatestVersion((Object)extractionNamespace.getUriPrefix(), versionRegex);
                    if (uri == null) {
                        throw new RuntimeException(new FileNotFoundException(String.format("Could not find match for pattern `%s` in [%s] for %s", versionRegex, originalUri, extractionNamespace)));
                    }
                } else {
                    uri = extractionNamespace.getUri();
                }
                final String uriPath = uri.getPath();
                try {
                    return (String)RetryUtils.retry((Callable)new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            ByteSource source;
                            String version = puller.getVersion(uri);
                            try {
                                long lastModified = Long.parseLong(version);
                                if (lastModified <= lastCached) {
                                    DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
                                    log.debug("URI [%s] for namespace [%s] was las modified [%s] but was last cached [%s]. Skipping ", new Object[]{uri.toString(), id, fmt.print(lastModified), fmt.print(lastCached)});
                                    return version;
                                }
                            }
                            catch (NumberFormatException ex) {
                                log.debug((Throwable)ex, "Failed to get last modified timestamp. Assuming no timestamp", new Object[0]);
                            }
                            if (CompressionUtils.isGz((String)uriPath)) {
                                log.debug("Loading gz", new Object[0]);
                                source = new ByteSource(){

                                    public InputStream openStream() throws IOException {
                                        return CompressionUtils.gzipInputStream((InputStream)puller.getInputStream(uri));
                                    }
                                };
                            } else {
                                source = new ByteSource(){

                                    public InputStream openStream() throws IOException {
                                        return puller.getInputStream(uri);
                                    }
                                };
                            }
                            long lineCount = new MapPopulator<String, String>(extractionNamespace.getNamespaceParseSpec().getParser()).populate(source, cache);
                            log.info("Finished loading %d lines for namespace [%s]", new Object[]{lineCount, id});
                            return version;
                        }
                    }, (Predicate)puller.shouldRetryPredicate(), (int)3);
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }
}

