/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.lookup.namespace.cache;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.concurrent.ExecutorServices;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.query.lookup.namespace.ExtractionNamespace;
import io.druid.query.lookup.namespace.ExtractionNamespaceCacheFactory;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public abstract class NamespaceExtractionCacheManager {
    private static final Logger log = new Logger(NamespaceExtractionCacheManager.class);
    private final ListeningScheduledExecutorService listeningScheduledExecutorService;
    protected final ConcurrentMap<String, NamespaceImplData> implData = new ConcurrentHashMap<String, NamespaceImplData>();
    protected final AtomicLong tasksStarted = new AtomicLong(0L);
    protected final ServiceEmitter serviceEmitter;
    private final ConcurrentHashMap<String, String> lastVersion = new ConcurrentHashMap();
    private final Map<Class<? extends ExtractionNamespace>, ExtractionNamespaceCacheFactory<?>> namespaceFunctionFactoryMap;

    public NamespaceExtractionCacheManager(Lifecycle lifecycle, final ServiceEmitter serviceEmitter, Map<Class<? extends ExtractionNamespace>, ExtractionNamespaceCacheFactory<?>> namespaceFunctionFactoryMap) {
        this.listeningScheduledExecutorService = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("NamespaceExtractionCacheManager-%d").setPriority(1).build()));
        ExecutorServices.manageLifecycle((Lifecycle)lifecycle, (ExecutorService)this.listeningScheduledExecutorService);
        this.serviceEmitter = serviceEmitter;
        this.namespaceFunctionFactoryMap = namespaceFunctionFactoryMap;
        this.listeningScheduledExecutorService.scheduleAtFixedRate(new Runnable(){
            long priorTasksStarted = 0L;

            @Override
            public void run() {
                block2: {
                    try {
                        long tasks = NamespaceExtractionCacheManager.this.tasksStarted.get();
                        serviceEmitter.emit(ServiceMetricEvent.builder().build("namespace/deltaTasksStarted", (Number)(tasks - this.priorTasksStarted)));
                        this.priorTasksStarted = tasks;
                        NamespaceExtractionCacheManager.this.monitor(serviceEmitter);
                    }
                    catch (Exception e) {
                        log.error((Throwable)e, "Error emitting namespace stats", new Object[0]);
                        if (!Thread.currentThread().isInterrupted()) break block2;
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            }
        }, 1L, 10L, TimeUnit.MINUTES);
    }

    protected void monitor(ServiceEmitter serviceEmitter) {
    }

    protected boolean waitForServiceToEnd(long time, TimeUnit unit) throws InterruptedException {
        return this.listeningScheduledExecutorService.awaitTermination(time, unit);
    }

    protected <T extends ExtractionNamespace> Runnable getPostRunnable(final String id, T namespace, ExtractionNamespaceCacheFactory<T> factory, final String cacheId) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NamespaceImplData namespaceDatum = (NamespaceImplData)NamespaceExtractionCacheManager.this.implData.get(id);
                if (namespaceDatum == null) {
                    return;
                }
                AtomicBoolean atomicBoolean = namespaceDatum.enabled;
                synchronized (atomicBoolean) {
                    try {
                        if (!namespaceDatum.enabled.get()) {
                            return;
                        }
                        NamespaceExtractionCacheManager.this.swapAndClearCache(id, cacheId);
                    }
                    finally {
                        namespaceDatum.firstRun.countDown();
                    }
                }
            }
        };
    }

    public boolean checkedDelete(String namespaceName) {
        NamespaceImplData implDatum = (NamespaceImplData)this.implData.get(namespaceName);
        if (implDatum == null) {
            log.wtf("Asked to delete something I just lost [%s]", new Object[]{namespaceName});
            return false;
        }
        return this.delete(namespaceName);
    }

    public boolean scheduleOrUpdate(String id, ExtractionNamespace namespace) {
        NamespaceImplData implDatum = (NamespaceImplData)this.implData.get(id);
        if (implDatum == null) {
            this.schedule(id, namespace);
            return true;
        }
        if (!implDatum.enabled.get()) {
            this.schedule(id, namespace);
            return true;
        }
        if (implDatum.namespace.equals(namespace)) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Namespace [%s] needs updated to [%s]", new Object[]{implDatum.namespace, namespace});
        }
        this.removeNamespaceLocalMetadata(implDatum);
        this.schedule(id, namespace);
        return true;
    }

    public boolean scheduleAndWait(String id, ExtractionNamespace namespace, long waitForFirstRun) {
        if (this.scheduleOrUpdate(id, namespace)) {
            log.debug("Scheduled new namespace [%s]: %s", new Object[]{id, namespace});
        } else {
            log.debug("Namespace [%s] already running: %s", new Object[]{id, namespace});
        }
        NamespaceImplData namespaceImplData = (NamespaceImplData)this.implData.get(id);
        if (namespaceImplData == null) {
            log.warn("NamespaceLookupExtractorFactory[%s] - deleted during start", new Object[]{id});
            return false;
        }
        boolean success = false;
        try {
            success = namespaceImplData.firstRun.await(waitForFirstRun, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.error((Throwable)e, "NamespaceLookupExtractorFactory[%s] - interrupted during start", new Object[]{id});
        }
        if (!success) {
            this.delete(id);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelFuture(final NamespaceImplData implDatum) {
        AtomicBoolean atomicBoolean = implDatum.enabled;
        synchronized (atomicBoolean) {
            final CountDownLatch latch = new CountDownLatch(1);
            ListenableFuture<?> future = implDatum.future;
            Futures.addCallback(future, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    latch.countDown();
                }

                public void onFailure(Throwable t) {
                    latch.countDown();
                    if (!(t instanceof CancellationException)) {
                        log.error(t, "Error in namespace [%s]", new Object[]{implDatum.name});
                    }
                }
            });
            if (!future.isDone() && !future.cancel(true)) {
                throw new ISE("Future for namespace [%s] was not able to be canceled", new Object[]{implDatum.name});
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeNamespaceLocalMetadata(NamespaceImplData implDatum) {
        if (implDatum == null) {
            return false;
        }
        AtomicBoolean atomicBoolean = implDatum.enabled;
        synchronized (atomicBoolean) {
            if (!implDatum.enabled.compareAndSet(true, false)) {
                return false;
            }
            if (!implDatum.future.isDone()) {
                this.cancelFuture(implDatum);
            }
            return this.implData.remove(implDatum.name, implDatum);
        }
    }

    public <T extends ExtractionNamespace> ListenableFuture<?> schedule(String id, T namespace) {
        ExtractionNamespaceCacheFactory<?> factory = this.namespaceFunctionFactoryMap.get(namespace.getClass());
        if (factory == null) {
            throw new ISE("Cannot find factory for namespace [%s]", new Object[]{namespace});
        }
        String cacheId = UUID.randomUUID().toString();
        return this.schedule(id, namespace, factory, this.getPostRunnable(id, namespace, factory, cacheId), cacheId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends ExtractionNamespace> ListenableFuture<?> schedule(final String id, final T namespace, final ExtractionNamespaceCacheFactory<T> factory, final Runnable postRunnable, final String cacheId) {
        log.debug("Trying to update namespace [%s]", new Object[]{id});
        NamespaceImplData implDatum = (NamespaceImplData)this.implData.get(id);
        if (implDatum != null) {
            AtomicBoolean atomicBoolean = implDatum.enabled;
            synchronized (atomicBoolean) {
                if (implDatum.enabled.get()) {
                    throw new IAE("Namespace [%s] already exists! Leaving prior running", new Object[]{namespace.toString()});
                }
            }
        }
        long updateMs = namespace.getPollMs();
        final CountDownLatch startLatch = new CountDownLatch(1);
        Runnable command = new Runnable(){

            @Override
            public void run() {
                block7: {
                    try {
                        startLatch.await();
                        if (!Thread.currentThread().isInterrupted()) {
                            ConcurrentMap<String, String> cache = NamespaceExtractionCacheManager.this.getCacheMap(cacheId);
                            String preVersion = (String)NamespaceExtractionCacheManager.this.lastVersion.get(id);
                            Callable<String> runnable = factory.getCachePopulator(id, namespace, preVersion, cache);
                            NamespaceExtractionCacheManager.this.tasksStarted.incrementAndGet();
                            String newVersion = runnable.call();
                            if (preVersion != null && preVersion.equals(newVersion)) {
                                throw new CancellationException(String.format("Version `%s` already exists", preVersion));
                            }
                            if (newVersion != null) {
                                NamespaceExtractionCacheManager.this.lastVersion.put(id, newVersion);
                            }
                            postRunnable.run();
                            log.debug("Namespace [%s] successfully updated", new Object[]{id});
                        }
                    }
                    catch (Throwable t) {
                        NamespaceExtractionCacheManager.this.delete(cacheId);
                        if (t instanceof CancellationException) {
                            log.debug(t, "Namespace [%s] cancelled", new Object[]{id});
                        } else {
                            log.error(t, "Failed update namespace [%s]", new Object[]{namespace});
                        }
                        if (!Thread.currentThread().isInterrupted()) break block7;
                        throw Throwables.propagate((Throwable)t);
                    }
                }
            }
        };
        try {
            ListenableScheduledFuture future = updateMs > 0L ? this.listeningScheduledExecutorService.scheduleAtFixedRate(command, 0L, updateMs, TimeUnit.MILLISECONDS) : this.listeningScheduledExecutorService.schedule(command, 0L, TimeUnit.MILLISECONDS);
            NamespaceImplData me = new NamespaceImplData((ListenableFuture<?>)future, namespace, id);
            NamespaceImplData other = this.implData.putIfAbsent(id, me);
            if (other != null) {
                if (!future.isDone() && !future.cancel(true)) {
                    log.warn("Unable to cancel future for namespace[%s] on race loss", new Object[]{id});
                }
                throw new IAE("Namespace [%s] already exists! Leaving prior running", new Object[]{namespace});
            }
            if (!me.enabled.compareAndSet(false, true)) {
                log.wtf("How did someone enable this before ME?", new Object[0]);
            }
            log.debug("I own namespace [%s]", new Object[]{id});
            ListenableScheduledFuture listenableScheduledFuture = future;
            return listenableScheduledFuture;
        }
        finally {
            startLatch.countDown();
        }
    }

    protected abstract boolean swapAndClearCache(String var1, String var2);

    public abstract ConcurrentMap<String, String> getCacheMap(String var1);

    public boolean delete(String ns) {
        NamespaceImplData implDatum = (NamespaceImplData)this.implData.get(ns);
        boolean deleted = this.removeNamespaceLocalMetadata(implDatum);
        if (deleted) {
            log.info("Deleting namespace [%s]", new Object[]{ns});
            this.lastVersion.remove(implDatum.name);
            return true;
        }
        log.debug("Did not delete namespace [%s]", new Object[]{ns});
        return false;
    }

    public String getVersion(String namespace) {
        if (namespace == null) {
            return null;
        }
        return this.lastVersion.get(namespace);
    }

    public Collection<String> getKnownIDs() {
        return this.implData.keySet();
    }

    protected static class NamespaceImplData {
        final ListenableFuture<?> future;
        final ExtractionNamespace namespace;
        final String name;
        final AtomicBoolean enabled = new AtomicBoolean(false);
        final CountDownLatch firstRun = new CountDownLatch(1);

        public NamespaceImplData(ListenableFuture<?> future, ExtractionNamespace namespace, String name) {
            this.future = future;
            this.namespace = namespace;
            this.name = name;
        }
    }
}

