/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.lookup.namespace.cache;

import com.google.common.util.concurrent.Striped;
import com.google.inject.Inject;
import com.metamx.common.IAE;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.query.lookup.namespace.ExtractionNamespace;
import io.druid.query.lookup.namespace.ExtractionNamespaceCacheFactory;
import io.druid.server.lookup.namespace.cache.NamespaceExtractionCacheManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;

public class OnHeapNamespaceExtractionCacheManager
extends NamespaceExtractionCacheManager {
    private static final Logger LOG = new Logger(OnHeapNamespaceExtractionCacheManager.class);
    private final ConcurrentMap<String, ConcurrentMap<String, String>> mapMap = new ConcurrentHashMap<String, ConcurrentMap<String, String>>();
    private final Striped<Lock> nsLocks = Striped.lock((int)32);

    @Inject
    public OnHeapNamespaceExtractionCacheManager(Lifecycle lifecycle, ServiceEmitter emitter, Map<Class<? extends ExtractionNamespace>, ExtractionNamespaceCacheFactory<?>> namespaceFunctionFactoryMap) {
        super(lifecycle, emitter, namespaceFunctionFactoryMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean swapAndClearCache(String namespaceKey, String cacheKey) {
        Lock lock = (Lock)this.nsLocks.get((Object)namespaceKey);
        lock.lock();
        try {
            ConcurrentMap cacheMap = (ConcurrentMap)this.mapMap.get(cacheKey);
            if (cacheMap == null) {
                throw new IAE("Extraction Cache [%s] does not exist", new Object[]{cacheKey});
            }
            ConcurrentMap<String, String> prior = this.mapMap.put(namespaceKey, cacheMap);
            this.mapMap.remove(cacheKey);
            if (prior != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public ConcurrentMap<String, String> getCacheMap(String namespaceOrCacheKey) {
        ConcurrentMap map = (ConcurrentMap)this.mapMap.get(namespaceOrCacheKey);
        if (map == null) {
            this.mapMap.putIfAbsent(namespaceOrCacheKey, new ConcurrentHashMap());
            map = (ConcurrentMap)this.mapMap.get(namespaceOrCacheKey);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String namespaceKey) {
        Lock lock = (Lock)this.nsLocks.get((Object)namespaceKey);
        lock.lock();
        try {
            boolean bl = super.delete(namespaceKey) && this.mapMap.remove(namespaceKey) != null;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    protected void monitor(ServiceEmitter serviceEmitter) {
        long numEntries = 0L;
        long size = 0L;
        for (Map.Entry entry : this.mapMap.entrySet()) {
            ConcurrentMap map = (ConcurrentMap)entry.getValue();
            if (map == null) {
                LOG.debug("missing cache key for reporting [%s]", new Object[]{entry.getKey()});
                continue;
            }
            numEntries += (long)map.size();
            for (Map.Entry sEntry : map.entrySet()) {
                String key = (String)sEntry.getKey();
                String value = (String)sEntry.getValue();
                if (key == null || value == null) {
                    LOG.debug("Missing entries for cache key [%s]", new Object[]{entry.getKey()});
                    continue;
                }
                size += (long)(key.length() + value.length());
            }
        }
        serviceEmitter.emit(ServiceMetricEvent.builder().build("namespace/cache/numEntries", (Number)numEntries));
        serviceEmitter.emit(ServiceMetricEvent.builder().build("namespace/cache/heapSizeInBytes", (Number)(size * 2L)));
    }
}

