/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.http.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.metamx.common.IAE;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.common.logger.Logger;
import com.metamx.http.client.AbstractHttpClient;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.Request;
import com.metamx.http.client.pool.ResourceContainer;
import com.metamx.http.client.pool.ResourcePool;
import com.metamx.http.client.response.ClientResponse;
import com.metamx.http.client.response.HttpResponseHandler;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.timeout.ReadTimeoutHandler;
import org.jboss.netty.util.Timer;
import org.joda.time.Duration;

public class NettyHttpClient
extends AbstractHttpClient {
    private static final Logger log = new Logger(NettyHttpClient.class);
    private static final String READ_TIMEOUT_HANDLER_NAME = "read-timeout";
    private static final String LAST_HANDLER_NAME = "last-handler";
    private final Timer timer;
    private final ResourcePool<String, ChannelFuture> pool;
    private final Duration defaultReadTimeout;

    public NettyHttpClient(ResourcePool<String, ChannelFuture> pool) {
        this(pool, null, null);
    }

    private NettyHttpClient(ResourcePool<String, ChannelFuture> pool, Duration defaultReadTimeout, Timer timer) {
        this.pool = (ResourcePool)Preconditions.checkNotNull(pool, (Object)"pool");
        this.defaultReadTimeout = defaultReadTimeout;
        this.timer = timer;
        if (defaultReadTimeout != null && defaultReadTimeout.getMillis() > 0L) {
            Preconditions.checkNotNull((Object)timer, (Object)"timer");
        }
    }

    @LifecycleStart
    public void start() {
    }

    @LifecycleStop
    public void stop() {
        this.pool.close();
    }

    public HttpClient withReadTimeout(Duration readTimeout) {
        return new NettyHttpClient(this.pool, readTimeout, this.timer);
    }

    public NettyHttpClient withTimer(Timer timer) {
        return new NettyHttpClient(this.pool, this.defaultReadTimeout, timer);
    }

    @Override
    public <Intermediate, Final> ListenableFuture<Final> go(Request request, final HttpResponseHandler<Intermediate, Final> handler, Duration requestReadTimeout) {
        String hostKey;
        ResourceContainer<ChannelFuture> channelResourceContainer;
        ChannelFuture channelFuture;
        HttpMethod method = request.getMethod();
        URL url = request.getUrl();
        Multimap<String, String> headers = request.getHeaders();
        final String requestDesc = String.format("%s %s", method, url);
        if (log.isDebugEnabled()) {
            log.debug("[%s] starting", new Object[]{requestDesc});
        }
        if (!(channelFuture = (channelResourceContainer = this.pool.take(hostKey = this.getPoolKey(url))).get().awaitUninterruptibly()).isSuccess()) {
            channelResourceContainer.returnResource();
            return Futures.immediateFailedFuture((Throwable)new ChannelException("Faulty channel in resource pool", channelFuture.getCause()));
        }
        final Channel channel = channelFuture.getChannel();
        String urlFile = Strings.nullToEmpty((String)url.getFile());
        DefaultHttpRequest httpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, method, urlFile.isEmpty() ? "/" : urlFile);
        if (!headers.containsKey((Object)"Host")) {
            httpRequest.headers().add("Host", (Object)this.getHost(url));
        }
        httpRequest.headers().set("Accept-Encoding", (Object)"gzip");
        for (Map.Entry entry : headers.asMap().entrySet()) {
            String key = (String)entry.getKey();
            for (String obj : (Collection)entry.getValue()) {
                httpRequest.headers().add(key, (Object)obj);
            }
        }
        if (request.hasContent()) {
            httpRequest.setContent(request.getContent());
        }
        final long readTimeout = this.getReadTimeout(requestReadTimeout);
        final SettableFuture retVal = SettableFuture.create();
        if (readTimeout > 0L) {
            channel.getPipeline().addLast(READ_TIMEOUT_HANDLER_NAME, (ChannelHandler)new ReadTimeoutHandler(this.timer, readTimeout, TimeUnit.MILLISECONDS));
        }
        channel.getPipeline().addLast(LAST_HANDLER_NAME, (ChannelHandler)new SimpleChannelUpstreamHandler(){
            private volatile ClientResponse<Intermediate> response = null;

            public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
                block13: {
                    if (log.isDebugEnabled()) {
                        log.debug("[%s] messageReceived: %s", new Object[]{requestDesc, e.getMessage()});
                    }
                    try {
                        Object msg = e.getMessage();
                        if (msg instanceof HttpResponse) {
                            HttpResponse httpResponse = (HttpResponse)msg;
                            if (log.isDebugEnabled()) {
                                log.debug("[%s] Got response: %s", new Object[]{requestDesc, httpResponse.getStatus()});
                            }
                            this.response = handler.handleResponse(httpResponse);
                            if (this.response.isFinished()) {
                                retVal.set(this.response.getObj());
                            }
                            if (!httpResponse.isChunked()) {
                                this.finishRequest();
                            }
                            break block13;
                        }
                        if (msg instanceof HttpChunk) {
                            HttpChunk httpChunk = (HttpChunk)msg;
                            if (log.isDebugEnabled()) {
                                log.debug("[%s] Got chunk: %sB, last=%s", new Object[]{requestDesc, httpChunk.getContent().readableBytes(), httpChunk.isLast()});
                            }
                            if (httpChunk.isLast()) {
                                this.finishRequest();
                            } else {
                                this.response = handler.handleChunk(this.response, httpChunk);
                                if (this.response.isFinished() && !retVal.isDone()) {
                                    retVal.set(this.response.getObj());
                                }
                            }
                            break block13;
                        }
                        throw new IllegalStateException(String.format("Unknown message type[%s]", msg.getClass()));
                    }
                    catch (Exception ex) {
                        log.warn((Throwable)ex, "[%s] Exception thrown while processing message, closing channel.", new Object[]{requestDesc});
                        if (!retVal.isDone()) {
                            retVal.set(null);
                        }
                        channel.close();
                        channelResourceContainer.returnResource();
                        throw ex;
                    }
                }
            }

            private void finishRequest() {
                ClientResponse finalResponse = handler.done(this.response);
                if (!finalResponse.isFinished()) {
                    throw new IllegalStateException(String.format("[%s] Didn't get a completed ClientResponse Object from [%s]", requestDesc, handler.getClass()));
                }
                if (!retVal.isDone()) {
                    retVal.set(finalResponse.getObj());
                }
                this.removeHandlers();
                channelResourceContainer.returnResource();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void exceptionCaught(ChannelHandlerContext context, ExceptionEvent event) throws Exception {
                if (log.isDebugEnabled()) {
                    Throwable cause = event.getCause();
                    if (cause == null) {
                        log.debug("[%s] Caught exception", new Object[]{requestDesc});
                    } else {
                        log.debug(cause, "[%s] Caught exception", new Object[]{requestDesc});
                    }
                }
                retVal.setException(event.getCause());
                if (this.response != null) {
                    handler.exceptionCaught(this.response, event.getCause());
                }
                this.removeHandlers();
                try {
                    channel.close();
                }
                catch (Exception exception) {
                }
                finally {
                    channelResourceContainer.returnResource();
                }
                context.sendUpstream((ChannelEvent)event);
            }

            public void channelDisconnected(ChannelHandlerContext context, ChannelStateEvent event) throws Exception {
                if (log.isDebugEnabled()) {
                    log.debug("[%s] Channel disconnected", new Object[]{requestDesc});
                }
                if (this.response != null) {
                    handler.exceptionCaught(this.response, (Throwable)new ChannelException("Channel disconnected"));
                }
                channel.close();
                channelResourceContainer.returnResource();
                if (!retVal.isDone()) {
                    log.warn("[%s] Channel disconnected before response complete", new Object[]{requestDesc});
                    retVal.setException((Throwable)new ChannelException("Channel disconnected"));
                }
                context.sendUpstream((ChannelEvent)event);
            }

            private void removeHandlers() {
                if (readTimeout > 0L) {
                    channel.getPipeline().remove(NettyHttpClient.READ_TIMEOUT_HANDLER_NAME);
                }
                channel.getPipeline().remove(NettyHttpClient.LAST_HANDLER_NAME);
            }
        });
        channel.write((Object)httpRequest).addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    channel.close();
                    channelResourceContainer.returnResource();
                    if (!retVal.isDone()) {
                        retVal.setException((Throwable)new ChannelException(String.format("[%s] Failed to write request to channel", requestDesc), future.getCause()));
                    }
                }
            }
        });
        return retVal;
    }

    private long getReadTimeout(Duration requestReadTimeout) {
        long timeout = requestReadTimeout != null ? requestReadTimeout.getMillis() : (this.defaultReadTimeout != null ? this.defaultReadTimeout.getMillis() : 0L);
        if (timeout > 0L && this.timer == null) {
            log.warn("Cannot time out requests without a timer! Disabling timeout for this request.", new Object[0]);
            return 0L;
        }
        return timeout;
    }

    private String getHost(URL url) {
        int port = url.getPort();
        if (port == -1) {
            String protocol = url.getProtocol();
            if ("http".equalsIgnoreCase(protocol)) {
                port = 80;
            } else if ("https".equalsIgnoreCase(protocol)) {
                port = 443;
            } else {
                throw new IAE("Cannot figure out default port for protocol[%s], please set Host header.", new Object[]{protocol});
            }
        }
        return String.format("%s:%s", url.getHost(), port);
    }

    private String getPoolKey(URL url) {
        return String.format("%s://%s:%s", url.getProtocol(), url.getHost(), url.getPort() == -1 ? url.getDefaultPort() : url.getPort());
    }
}

