/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip2;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.maxmind.geoip2.GeoIp2Provider;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.City;
import com.maxmind.geoip2.model.CityIspOrg;
import com.maxmind.geoip2.model.Country;
import com.maxmind.geoip2.model.Omni;
import com.maxmind.maxminddb.MaxMindDbReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;

public class DatabaseReader
implements GeoIp2Provider,
Closeable {
    private final MaxMindDbReader reader;
    private final ObjectMapper om;

    public DatabaseReader(File database) throws IOException {
        this(database, Arrays.asList("en"));
    }

    public DatabaseReader(File database, List<String> languages) throws IOException {
        this.reader = new MaxMindDbReader(database);
        this.om = new ObjectMapper();
        this.om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        InjectableValues.Std inject = new InjectableValues.Std().addValue("languages", languages);
        this.om.setInjectableValues((InjectableValues)inject);
    }

    private <T> T get(InetAddress ipAddress, Class<T> cls) throws IOException, AddressNotFoundException {
        ObjectNode node = (ObjectNode)this.reader.get(ipAddress);
        if (node == null) {
            throw new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database.");
        }
        if (!node.has("traits")) {
            node.put("traits", (JsonNode)this.om.createObjectNode());
        }
        ObjectNode traits = (ObjectNode)node.get("traits");
        traits.put("ip_address", ipAddress.getHostAddress());
        return (T)this.om.treeToValue((TreeNode)node, cls);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public Country country(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, Country.class);
    }

    @Override
    public City city(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, City.class);
    }

    @Override
    public CityIspOrg cityIspOrg(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, CityIspOrg.class);
    }

    @Override
    public Omni omni(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.get(ipAddress, Omni.class);
    }
}

