/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.maxmind.geoip2.model.AbstractCountry;
import com.maxmind.geoip2.record.CityRecord;
import com.maxmind.geoip2.record.LocationRecord;
import com.maxmind.geoip2.record.PostalRecord;
import com.maxmind.geoip2.record.SubdivisionRecord;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractCity
extends AbstractCountry {
    @JsonProperty
    private CityRecord city = new CityRecord();
    @JsonProperty
    private LocationRecord location = new LocationRecord();
    @JsonProperty
    private PostalRecord postal = new PostalRecord();
    @JsonProperty(value="subdivisions")
    private ArrayList<SubdivisionRecord> subdivisions = new ArrayList();

    AbstractCity() {
    }

    public CityRecord getCity() {
        return this.city;
    }

    public LocationRecord getLocation() {
        return this.location;
    }

    public PostalRecord getPostal() {
        return this.postal;
    }

    public List<SubdivisionRecord> getSubdivisionsList() {
        return new ArrayList<SubdivisionRecord>(this.subdivisions);
    }

    public SubdivisionRecord getMostSpecificSubdivision() {
        if (this.subdivisions.isEmpty()) {
            return new SubdivisionRecord();
        }
        return this.subdivisions.get(this.subdivisions.size() - 1);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [" + (this.getCity() != null ? "getCity()=" + this.getCity() + ", " : "") + (this.getLocation() != null ? "getLocation()=" + this.getLocation() + ", " : "") + (this.getPostal() != null ? "getPostal()=" + this.getPostal() + ", " : "") + (this.getSubdivisionsList() != null ? "getSubdivisionsList()=" + this.getSubdivisionsList() + ", " : "") + (this.getContinent() != null ? "getContinent()=" + this.getContinent() + ", " : "") + (this.getCountry() != null ? "getCountry()=" + this.getCountry() + ", " : "") + (this.getRegisteredCountry() != null ? "getRegisteredCountry()=" + this.getRegisteredCountry() + ", " : "") + (this.getRepresentedCountry() != null ? "getRepresentedCountry()=" + this.getRepresentedCountry() + ", " : "") + (this.getTraits() != null ? "getTraits()=" + this.getTraits() : "") + "]";
    }
}

