/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.io.smoosh;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.metamx.common.ByteBufferUtils;
import com.metamx.common.ISE;
import com.metamx.common.io.smoosh.FileSmoosher;
import com.metamx.common.io.smoosh.Metadata;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SmooshedFileMapper
implements Closeable {
    private final List<File> outFiles;
    private final Map<String, Metadata> internalFiles;
    private final List<MappedByteBuffer> buffersList = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SmooshedFileMapper load(File baseDir) throws IOException {
        SmooshedFileMapper smooshedFileMapper;
        File metaFile = FileSmoosher.metaFile(baseDir);
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(metaFile), Charsets.UTF_8));
            String line = in.readLine();
            if (line == null) {
                throw new ISE("First line should be version,maxChunkSize,numChunks, got null.", new Object[0]);
            }
            String[] splits = line.split(",");
            if (!"v1".equals(splits[0])) {
                throw new ISE("Unknown version[%s], v1 is all I know.", splits[0]);
            }
            if (splits.length != 3) {
                throw new ISE("Wrong number of splits[%d] in line[%s]", splits.length, line);
            }
            Integer numFiles = Integer.valueOf(splits[2]);
            ArrayList outFiles = Lists.newArrayListWithExpectedSize((int)numFiles);
            for (int i = 0; i < numFiles; ++i) {
                outFiles.add(FileSmoosher.makeChunkFile(baseDir, i));
            }
            TreeMap internalFiles = Maps.newTreeMap();
            while ((line = in.readLine()) != null) {
                splits = line.split(",");
                if (splits.length != 4) {
                    throw new ISE("Wrong number of splits[%d] in line[%s]", splits.length, line);
                }
                internalFiles.put(splits[0], new Metadata(Integer.parseInt(splits[1]), Integer.parseInt(splits[2]), Integer.parseInt(splits[3])));
            }
            smooshedFileMapper = new SmooshedFileMapper(outFiles, internalFiles);
        }
        catch (Throwable throwable) {
            Closeables.close(in, (boolean)false);
            throw throwable;
        }
        Closeables.close((Closeable)in, (boolean)false);
        return smooshedFileMapper;
    }

    private SmooshedFileMapper(List<File> outFiles, Map<String, Metadata> internalFiles) {
        this.outFiles = outFiles;
        this.internalFiles = internalFiles;
    }

    public Set<String> getInternalFilenames() {
        return this.internalFiles.keySet();
    }

    public ByteBuffer mapFile(String name) throws IOException {
        Metadata metadata = this.internalFiles.get(name);
        if (metadata == null) {
            return null;
        }
        int fileNum = metadata.getFileNum();
        while (this.buffersList.size() <= fileNum) {
            this.buffersList.add(null);
        }
        MappedByteBuffer mappedBuffer = this.buffersList.get(fileNum);
        if (mappedBuffer == null) {
            mappedBuffer = Files.map((File)this.outFiles.get(fileNum));
            this.buffersList.set(fileNum, mappedBuffer);
        }
        ByteBuffer retVal = mappedBuffer.duplicate();
        retVal.position(metadata.getStartOffset()).limit(metadata.getEndOffset());
        return retVal.slice();
    }

    @Override
    public void close() throws IOException {
        for (MappedByteBuffer mappedByteBuffer : this.buffersList) {
            ByteBufferUtils.unmap(mappedByteBuffer);
        }
    }
}

