/*
 * Decompiled with CFR 0.152.
 */
package io.druid.firehose.s3;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.metamx.common.CompressionUtils;
import com.metamx.common.logger.Logger;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.impl.FileIteratingFirehose;
import io.druid.data.input.impl.StringInputRowParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;

public class StaticS3FirehoseFactory
implements FirehoseFactory<StringInputRowParser> {
    private static final Logger log = new Logger(StaticS3FirehoseFactory.class);
    private final RestS3Service s3Client;
    private final List<URI> uris;

    @JsonCreator
    public StaticS3FirehoseFactory(@JacksonInject(value="s3Client") RestS3Service s3Client, @JsonProperty(value="uris") List<URI> uris) {
        this.s3Client = s3Client;
        this.uris = ImmutableList.copyOf(uris);
        for (URI inputURI : uris) {
            Preconditions.checkArgument((boolean)inputURI.getScheme().equals("s3"), (String)"input uri scheme == s3 (%s)", (Object[])new Object[]{inputURI});
        }
    }

    @JsonProperty
    public List<URI> getUris() {
        return this.uris;
    }

    public Firehose connect(StringInputRowParser firehoseParser) throws IOException {
        Preconditions.checkNotNull((Object)this.s3Client, (Object)"null s3Client");
        final LinkedList objectQueue = Lists.newLinkedList(this.uris);
        return new FileIteratingFirehose((Iterator)new Iterator<LineIterator>(){

            @Override
            public boolean hasNext() {
                return !objectQueue.isEmpty();
            }

            @Override
            public LineIterator next() {
                URI nextURI = (URI)objectQueue.poll();
                String s3Bucket = nextURI.getAuthority();
                S3Object s3Object = new S3Object(nextURI.getPath().startsWith("/") ? nextURI.getPath().substring(1) : nextURI.getPath());
                log.info("Reading from bucket[%s] object[%s] (%s)", new Object[]{s3Bucket, s3Object.getKey(), nextURI});
                try {
                    InputStream innerInputStream = StaticS3FirehoseFactory.this.s3Client.getObject(new S3Bucket(s3Bucket), s3Object.getKey()).getDataInputStream();
                    InputStream outerInputStream = s3Object.getKey().endsWith(".gz") ? CompressionUtils.gzipInputStream((InputStream)innerInputStream) : innerInputStream;
                    return IOUtils.lineIterator((Reader)new BufferedReader(new InputStreamReader(outerInputStream, Charsets.UTF_8)));
                }
                catch (Exception e) {
                    log.error((Throwable)e, "Exception reading from bucket[%s] object[%s]", new Object[]{s3Bucket, s3Object.getKey()});
                    throw Throwables.propagate((Throwable)e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }, firehoseParser);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticS3FirehoseFactory factory = (StaticS3FirehoseFactory)o;
        return !(this.uris == null ? factory.uris != null : !this.uris.equals(factory.uris));
    }

    public int hashCode() {
        return this.uris != null ? this.uris.hashCode() : 0;
    }
}

