/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.s3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.inject.Inject;
import com.metamx.common.CompressionUtils;
import com.metamx.emitter.EmittingLogger;
import io.druid.segment.SegmentUtils;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.storage.s3.S3DataSegmentPusherConfig;
import io.druid.storage.s3.S3Utils;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.gs.GSAccessControlList;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Object;

public class S3DataSegmentPusher
implements DataSegmentPusher {
    private static final EmittingLogger log = new EmittingLogger(S3DataSegmentPusher.class);
    private final RestS3Service s3Client;
    private final S3DataSegmentPusherConfig config;
    private final ObjectMapper jsonMapper;

    @Inject
    public S3DataSegmentPusher(RestS3Service s3Client, S3DataSegmentPusherConfig config, ObjectMapper jsonMapper) {
        this.s3Client = s3Client;
        this.config = config;
        this.jsonMapper = jsonMapper;
        log.info("Configured S3 as deep storage", new Object[0]);
    }

    public String getPathForHadoop(String dataSource) {
        return String.format("s3n://%s/%s/%s", this.config.getBucket(), this.config.getBaseKey(), dataSource);
    }

    public DataSegment push(final File indexFilesDir, final DataSegment inSegment) throws IOException {
        final String s3Path = S3Utils.constructSegmentPath(this.config.getBaseKey(), inSegment);
        log.info("Copying segment[%s] to S3 at location[%s]", new Object[]{inSegment.getIdentifier(), s3Path});
        final File zipOutFile = File.createTempFile("druid", "index.zip");
        final long indexSize = CompressionUtils.zip((File)indexFilesDir, (File)zipOutFile);
        try {
            return S3Utils.retryS3Operation(new Callable<DataSegment>(){

                @Override
                public DataSegment call() throws Exception {
                    S3Object toPush = new S3Object(zipOutFile);
                    String outputBucket = S3DataSegmentPusher.this.config.getBucket();
                    String s3DescriptorPath = S3Utils.descriptorPathForSegmentPath(s3Path);
                    toPush.setBucketName(outputBucket);
                    toPush.setKey(s3Path);
                    if (!S3DataSegmentPusher.this.config.getDisableAcl()) {
                        toPush.setAcl((AccessControlList)GSAccessControlList.REST_CANNED_BUCKET_OWNER_FULL_CONTROL);
                    }
                    log.info("Pushing %s.", new Object[]{toPush});
                    S3DataSegmentPusher.this.s3Client.putObject(outputBucket, toPush);
                    DataSegment outSegment = inSegment.withSize(indexSize).withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"s3_zip", (Object)"bucket", (Object)outputBucket, (Object)"key", (Object)toPush.getKey())).withBinaryVersion(SegmentUtils.getVersionFromDir((File)indexFilesDir));
                    File descriptorFile = File.createTempFile("druid", "descriptor.json");
                    Files.copy((InputSupplier)ByteStreams.newInputStreamSupplier((byte[])S3DataSegmentPusher.this.jsonMapper.writeValueAsBytes((Object)inSegment)), (File)descriptorFile);
                    S3Object descriptorObject = new S3Object(descriptorFile);
                    descriptorObject.setBucketName(outputBucket);
                    descriptorObject.setKey(s3DescriptorPath);
                    if (!S3DataSegmentPusher.this.config.getDisableAcl()) {
                        descriptorObject.setAcl((AccessControlList)GSAccessControlList.REST_CANNED_BUCKET_OWNER_FULL_CONTROL);
                    }
                    log.info("Pushing %s", new Object[]{descriptorObject});
                    S3DataSegmentPusher.this.s3Client.putObject(outputBucket, descriptorObject);
                    log.info("Deleting zipped index File[%s]", new Object[]{zipOutFile});
                    zipOutFile.delete();
                    log.info("Deleting descriptor file[%s]", new Object[]{descriptorFile});
                    descriptorFile.delete();
                    return outSegment;
                }
            });
        }
        catch (ServiceException e) {
            throw new IOException(e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

