/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.s3;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.multibindings.MapBinder;
import io.druid.common.aws.AWSCredentialsConfig;
import io.druid.common.aws.AWSCredentialsUtils;
import io.druid.data.SearchableVersionedDataFinder;
import io.druid.guice.Binders;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.initialization.DruidModule;
import io.druid.storage.s3.AWSSessionCredentialsAdapter;
import io.druid.storage.s3.S3DataSegmentArchiver;
import io.druid.storage.s3.S3DataSegmentArchiverConfig;
import io.druid.storage.s3.S3DataSegmentKiller;
import io.druid.storage.s3.S3DataSegmentMover;
import io.druid.storage.s3.S3DataSegmentPuller;
import io.druid.storage.s3.S3DataSegmentPusher;
import io.druid.storage.s3.S3DataSegmentPusherConfig;
import io.druid.storage.s3.S3LoadSpec;
import io.druid.storage.s3.S3TaskLogs;
import io.druid.storage.s3.S3TaskLogsConfig;
import io.druid.storage.s3.S3TimestampVersionedDataFinder;
import java.util.List;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;

public class S3StorageDruidModule
implements DruidModule {
    public static final String SCHEME = "s3_zip";

    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of((Object)new Module(){

            public String getModuleName() {
                return "DruidS3-" + System.identityHashCode((Object)this);
            }

            public Version version() {
                return Version.unknownVersion();
            }

            public void setupModule(Module.SetupContext context) {
                context.registerSubtypes(new Class[]{S3LoadSpec.class});
            }
        });
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.s3", AWSCredentialsConfig.class);
        MapBinder.newMapBinder((Binder)binder, String.class, SearchableVersionedDataFinder.class).addBinding((Object)"s3").to(S3TimestampVersionedDataFinder.class).in(LazySingleton.class);
        MapBinder.newMapBinder((Binder)binder, String.class, SearchableVersionedDataFinder.class).addBinding((Object)"s3n").to(S3TimestampVersionedDataFinder.class).in(LazySingleton.class);
        Binders.dataSegmentPullerBinder((Binder)binder).addBinding((Object)SCHEME).to(S3DataSegmentPuller.class).in(LazySingleton.class);
        Binders.dataSegmentKillerBinder((Binder)binder).addBinding((Object)SCHEME).to(S3DataSegmentKiller.class).in(LazySingleton.class);
        Binders.dataSegmentMoverBinder((Binder)binder).addBinding((Object)SCHEME).to(S3DataSegmentMover.class).in(LazySingleton.class);
        Binders.dataSegmentArchiverBinder((Binder)binder).addBinding((Object)SCHEME).to(S3DataSegmentArchiver.class).in(LazySingleton.class);
        Binders.dataSegmentPusherBinder((Binder)binder).addBinding((Object)"s3").to(S3DataSegmentPusher.class).in(LazySingleton.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.storage", S3DataSegmentPusherConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.storage", S3DataSegmentArchiverConfig.class);
        Binders.taskLogsBinder((Binder)binder).addBinding((Object)"s3").to(S3TaskLogs.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.logs", S3TaskLogsConfig.class);
        binder.bind(S3TaskLogs.class).in(LazySingleton.class);
    }

    @Provides
    @LazySingleton
    public AWSCredentialsProvider getAWSCredentialsProvider(AWSCredentialsConfig config) {
        return AWSCredentialsUtils.defaultAWSCredentialsProviderChain((AWSCredentialsConfig)config);
    }

    @Provides
    @LazySingleton
    public RestS3Service getRestS3Service(AWSCredentialsProvider provider) {
        if (provider.getCredentials() instanceof AWSSessionCredentials) {
            return new RestS3Service((ProviderCredentials)new AWSSessionCredentialsAdapter(provider));
        }
        return new RestS3Service((ProviderCredentials)new AWSCredentials(provider.getCredentials().getAWSAccessKeyId(), provider.getCredentials().getAWSSecretKey()));
    }
}

