/*
 * Decompiled with CFR 0.152.
 */
package io.druid.storage.s3;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.metamx.common.RetryUtils;
import io.druid.data.SearchableVersionedDataFinder;
import io.druid.storage.s3.S3DataSegmentPuller;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Object;

public class S3TimestampVersionedDataFinder
extends S3DataSegmentPuller
implements SearchableVersionedDataFinder<URI> {
    @Inject
    public S3TimestampVersionedDataFinder(RestS3Service s3Client) {
        super(s3Client);
    }

    public URI getLatestVersion(final URI uri, final @Nullable Pattern pattern) {
        try {
            return (URI)RetryUtils.retry((Callable)new Callable<URI>(){

                @Override
                public URI call() throws Exception {
                    S3DataSegmentPuller.S3Coords coords = new S3DataSegmentPuller.S3Coords(S3DataSegmentPuller.checkURI(uri));
                    long mostRecent = Long.MIN_VALUE;
                    URI latest = null;
                    S3Object[] objects = S3TimestampVersionedDataFinder.this.s3Client.listObjects(coords.bucket, coords.path, null);
                    if (objects == null) {
                        return null;
                    }
                    for (S3Object storageObject : objects) {
                        long latestModified;
                        storageObject.closeDataInputStream();
                        String keyString = storageObject.getKey().substring(coords.path.length());
                        if (keyString.startsWith("/")) {
                            keyString = keyString.substring(1);
                        }
                        if (pattern != null && !pattern.matcher(keyString).matches() || (latestModified = storageObject.getLastModifiedDate().getTime()) < mostRecent) continue;
                        mostRecent = latestModified;
                        latest = new URI(String.format("s3://%s/%s", storageObject.getBucketName(), storageObject.getKey()));
                    }
                    return latest;
                }
            }, this.shouldRetryPredicate(), (int)3);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Class<URI> getDataDescriptorClass() {
        return URI.class;
    }
}

