/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.metamx.common.Pair;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.http.client.HttpClient;
import io.druid.client.BrokerSegmentWatcherConfig;
import io.druid.client.DirectDruidClient;
import io.druid.client.DruidServer;
import io.druid.client.FilteredServerInventoryView;
import io.druid.client.ServerView;
import io.druid.client.TimelineServerView;
import io.druid.client.selector.QueryableDruidServer;
import io.druid.client.selector.ServerSelector;
import io.druid.client.selector.TierSelectorStrategy;
import io.druid.concurrent.Execs;
import io.druid.guice.annotations.Client;
import io.druid.guice.annotations.Smile;
import io.druid.query.DataSource;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChestWarehouse;
import io.druid.query.QueryWatcher;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.timeline.DataSegment;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.PartitionChunk;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class BrokerServerView
implements TimelineServerView {
    private static final Logger log = new Logger(BrokerServerView.class);
    private final Object lock = new Object();
    private final ConcurrentMap<String, QueryableDruidServer> clients;
    private final Map<String, ServerSelector> selectors;
    private final Map<String, VersionedIntervalTimeline<String, ServerSelector>> timelines;
    private final QueryToolChestWarehouse warehouse;
    private final QueryWatcher queryWatcher;
    private final ObjectMapper smileMapper;
    private final HttpClient httpClient;
    private final FilteredServerInventoryView baseView;
    private final TierSelectorStrategy tierSelectorStrategy;
    private final ServiceEmitter emitter;
    private final Predicate<Pair<DruidServerMetadata, DataSegment>> segmentFilter;
    private volatile boolean initialized = false;

    @Inject
    public BrokerServerView(QueryToolChestWarehouse warehouse, QueryWatcher queryWatcher, @Smile ObjectMapper smileMapper, @Client HttpClient httpClient, FilteredServerInventoryView baseView, TierSelectorStrategy tierSelectorStrategy, ServiceEmitter emitter, final BrokerSegmentWatcherConfig segmentWatcherConfig) {
        this.warehouse = warehouse;
        this.queryWatcher = queryWatcher;
        this.smileMapper = smileMapper;
        this.httpClient = httpClient;
        this.baseView = baseView;
        this.tierSelectorStrategy = tierSelectorStrategy;
        this.emitter = emitter;
        this.clients = Maps.newConcurrentMap();
        this.selectors = Maps.newHashMap();
        this.timelines = Maps.newHashMap();
        this.segmentFilter = new Predicate<Pair<DruidServerMetadata, DataSegment>>(){

            public boolean apply(Pair<DruidServerMetadata, DataSegment> input) {
                if (segmentWatcherConfig.getWatchedTiers() != null && !segmentWatcherConfig.getWatchedTiers().contains(((DruidServerMetadata)input.lhs).getTier())) {
                    return false;
                }
                return segmentWatcherConfig.getWatchedDataSources() == null || segmentWatcherConfig.getWatchedDataSources().contains(((DataSegment)input.rhs).getDataSource());
            }
        };
        ExecutorService exec = Execs.singleThreaded((String)"BrokerServerView-%s");
        baseView.registerSegmentCallback(exec, new ServerView.SegmentCallback(){

            @Override
            public ServerView.CallbackAction segmentAdded(DruidServerMetadata server, DataSegment segment) {
                BrokerServerView.this.serverAddedSegment(server, segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            @Override
            public ServerView.CallbackAction segmentRemoved(DruidServerMetadata server, DataSegment segment) {
                BrokerServerView.this.serverRemovedSegment(server, segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            @Override
            public ServerView.CallbackAction segmentViewInitialized() {
                BrokerServerView.this.initialized = true;
                return ServerView.CallbackAction.CONTINUE;
            }
        }, this.segmentFilter);
        baseView.registerServerCallback(exec, new ServerView.ServerCallback(){

            @Override
            public ServerView.CallbackAction serverRemoved(DruidServer server) {
                BrokerServerView.this.removeServer(server);
                return ServerView.CallbackAction.CONTINUE;
            }
        });
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            Iterator clientsIter = this.clients.keySet().iterator();
            while (clientsIter.hasNext()) {
                clientsIter.remove();
            }
            this.timelines.clear();
            Iterator<ServerSelector> selectorsIter = this.selectors.values().iterator();
            while (selectorsIter.hasNext()) {
                ServerSelector selector = selectorsIter.next();
                selectorsIter.remove();
                while (!selector.isEmpty()) {
                    QueryableDruidServer pick = selector.pick();
                    selector.removeServer(pick);
                }
            }
        }
    }

    private QueryableDruidServer addServer(DruidServer server) {
        QueryableDruidServer retVal = new QueryableDruidServer(server, this.makeDirectClient(server));
        QueryableDruidServer exists = this.clients.put(server.getName(), retVal);
        if (exists != null) {
            log.warn("QueryRunner for server[%s] already existed!? Well it's getting replaced", new Object[]{server});
        }
        return retVal;
    }

    private DirectDruidClient makeDirectClient(DruidServer server) {
        return new DirectDruidClient(this.warehouse, this.queryWatcher, this.smileMapper, this.httpClient, server.getHost(), this.emitter);
    }

    private QueryableDruidServer removeServer(DruidServer server) {
        for (DataSegment segment : server.getSegments().values()) {
            this.serverRemovedSegment(server.getMetadata(), segment);
        }
        return (QueryableDruidServer)this.clients.remove(server.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverAddedSegment(DruidServerMetadata server, DataSegment segment) {
        String segmentId = segment.getIdentifier();
        Object object = this.lock;
        synchronized (object) {
            QueryableDruidServer queryableDruidServer;
            log.debug("Adding segment[%s] for server[%s]", new Object[]{segment, server});
            ServerSelector selector = this.selectors.get(segmentId);
            if (selector == null) {
                selector = new ServerSelector(segment, this.tierSelectorStrategy);
                VersionedIntervalTimeline timeline = this.timelines.get(segment.getDataSource());
                if (timeline == null) {
                    timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural());
                    this.timelines.put(segment.getDataSource(), (VersionedIntervalTimeline<String, ServerSelector>)timeline);
                }
                timeline.add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)selector));
                this.selectors.put(segmentId, selector);
            }
            if ((queryableDruidServer = (QueryableDruidServer)this.clients.get(server.getName())) == null) {
                queryableDruidServer = this.addServer(this.baseView.getInventoryValue(server.getName()));
            }
            selector.addServerAndUpdateSegment(queryableDruidServer, segment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverRemovedSegment(DruidServerMetadata server, DataSegment segment) {
        String segmentId = segment.getIdentifier();
        Object object = this.lock;
        synchronized (object) {
            log.debug("Removing segment[%s] from server[%s].", new Object[]{segmentId, server});
            ServerSelector selector = this.selectors.get(segmentId);
            if (selector == null) {
                log.warn("Told to remove non-existant segment[%s]", new Object[]{segmentId});
                return;
            }
            QueryableDruidServer queryableDruidServer = (QueryableDruidServer)this.clients.get(server.getName());
            if (!selector.removeServer(queryableDruidServer)) {
                log.warn("Asked to disassociate non-existant association between server[%s] and segment[%s]", new Object[]{server, segmentId});
            }
            if (selector.isEmpty()) {
                VersionedIntervalTimeline<String, ServerSelector> timeline = this.timelines.get(segment.getDataSource());
                this.selectors.remove(segmentId);
                PartitionChunk removedPartition = timeline.remove(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)selector));
                if (removedPartition == null) {
                    log.warn("Asked to remove timeline entry[interval: %s, version: %s] that doesn't exist", new Object[]{segment.getInterval(), segment.getVersion()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionedIntervalTimeline<String, ServerSelector> getTimeline(DataSource dataSource) {
        String table = (String)Iterables.getOnlyElement((Iterable)dataSource.getNames());
        Object object = this.lock;
        synchronized (object) {
            return this.timelines.get(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> QueryRunner<T> getQueryRunner(DruidServer server) {
        Object object = this.lock;
        synchronized (object) {
            QueryableDruidServer queryableDruidServer = (QueryableDruidServer)this.clients.get(server.getName());
            if (queryableDruidServer == null) {
                log.error("WTF?! No QueryableDruidServer found for %s", new Object[]{server.getName()});
                return null;
            }
            return queryableDruidServer.getClient();
        }
    }

    @Override
    public void registerServerCallback(Executor exec, ServerView.ServerCallback callback) {
        this.baseView.registerServerCallback(exec, callback);
    }

    @Override
    public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback) {
        this.baseView.registerSegmentCallback(exec, callback, this.segmentFilter);
    }
}

