/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.metamx.common.IAE;
import com.metamx.common.Pair;
import com.metamx.common.RE;
import com.metamx.common.guava.BaseSequence;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.Request;
import com.metamx.http.client.response.ClientResponse;
import com.metamx.http.client.response.HttpResponseHandler;
import com.metamx.http.client.response.StatusResponseHandler;
import com.metamx.http.client.response.StatusResponseHolder;
import io.druid.query.BaseQuery;
import io.druid.query.BySegmentResultValueClass;
import io.druid.query.Query;
import io.druid.query.QueryInterruptedException;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryToolChestWarehouse;
import io.druid.query.QueryWatcher;
import io.druid.query.Result;
import io.druid.query.aggregation.MetricManipulatorFns;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class DirectDruidClient<T>
implements QueryRunner<T> {
    private static final Logger log = new Logger(DirectDruidClient.class);
    private static final Map<Class<? extends Query>, Pair<JavaType, JavaType>> typesMap = Maps.newConcurrentMap();
    private final QueryToolChestWarehouse warehouse;
    private final QueryWatcher queryWatcher;
    private final ObjectMapper objectMapper;
    private final HttpClient httpClient;
    private final String host;
    private final ServiceEmitter emitter;
    private final AtomicInteger openConnections;
    private final boolean isSmile;

    public DirectDruidClient(QueryToolChestWarehouse warehouse, QueryWatcher queryWatcher, ObjectMapper objectMapper, HttpClient httpClient, String host, ServiceEmitter emitter) {
        this.warehouse = warehouse;
        this.queryWatcher = queryWatcher;
        this.objectMapper = objectMapper;
        this.httpClient = httpClient;
        this.host = host;
        this.emitter = emitter;
        this.isSmile = this.objectMapper.getFactory() instanceof SmileFactory;
        this.openConnections = new AtomicInteger();
    }

    public int getNumOpenConnections() {
        return this.openConnections.get();
    }

    public Sequence<T> run(final Query<T> query, final Map<String, Object> context) {
        ListenableFuture future;
        QueryToolChest toolChest = this.warehouse.getToolChest(query);
        boolean isBySegment = BaseQuery.getContextBySegment(query, (boolean)false);
        Pair types = typesMap.get(query.getClass());
        if (types == null) {
            TypeFactory typeFactory = this.objectMapper.getTypeFactory();
            JavaType baseType = typeFactory.constructType(toolChest.getResultTypeReference());
            JavaType bySegmentType = typeFactory.constructParametricType(Result.class, new JavaType[]{typeFactory.constructParametricType(BySegmentResultValueClass.class, new JavaType[]{baseType})});
            types = Pair.of((Object)baseType, (Object)bySegmentType);
            typesMap.put(query.getClass(), (Pair<JavaType, JavaType>)types);
        }
        final JavaType typeRef = isBySegment ? (JavaType)types.rhs : (JavaType)types.lhs;
        final String url = String.format("http://%s/druid/v2/", this.host);
        final String cancelUrl = String.format("http://%s/druid/v2/%s", this.host, query.getId());
        try {
            log.debug("Querying queryId[%s] url[%s]", new Object[]{query.getId(), url});
            final long requestStartTime = System.currentTimeMillis();
            final ServiceMetricEvent.Builder builder = toolChest.makeMetricBuilder(query);
            builder.setDimension("server", this.host);
            builder.setDimension("id", Strings.nullToEmpty((String)query.getId()));
            HttpResponseHandler<InputStream, InputStream> responseHandler = new HttpResponseHandler<InputStream, InputStream>(){
                private long responseStartTime;
                private final AtomicLong byteCount = new AtomicLong(0L);
                private final BlockingQueue<InputStream> queue = new LinkedBlockingQueue<InputStream>();
                private final AtomicBoolean done = new AtomicBoolean(false);

                public ClientResponse<InputStream> handleResponse(HttpResponse response) {
                    log.debug("Initial response from url[%s] for queryId[%s]", new Object[]{url, query.getId()});
                    this.responseStartTime = System.currentTimeMillis();
                    DirectDruidClient.this.emitter.emit(builder.build("query/node/ttfb", (Number)(this.responseStartTime - requestStartTime)));
                    try {
                        String responseContext = response.headers().get("X-Druid-Response-Context");
                        if (responseContext != null) {
                            context.putAll((Map)DirectDruidClient.this.objectMapper.readValue(responseContext, (TypeReference)new TypeReference<Map<String, Object>>(){}));
                        }
                        this.queue.put((InputStream)new ChannelBufferInputStream(response.getContent()));
                    }
                    catch (IOException e) {
                        log.error((Throwable)e, "Error parsing response context from url [%s]", new Object[]{url});
                        return ClientResponse.finished((Object)new InputStream(){

                            @Override
                            public int read() throws IOException {
                                throw e;
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        log.error((Throwable)e, "Queue appending interrupted", new Object[0]);
                        Thread.currentThread().interrupt();
                        throw Throwables.propagate((Throwable)e);
                    }
                    this.byteCount.addAndGet(response.getContent().readableBytes());
                    return ClientResponse.finished((Object)new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public boolean hasMoreElements() {
                            AtomicBoolean atomicBoolean = done;
                            synchronized (atomicBoolean) {
                                return !done.get() || !queue.isEmpty();
                            }
                        }

                        @Override
                        public InputStream nextElement() {
                            try {
                                return (InputStream)queue.take();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw Throwables.propagate((Throwable)e);
                            }
                        }
                    }));
                }

                public ClientResponse<InputStream> handleChunk(ClientResponse<InputStream> clientResponse, HttpChunk chunk) {
                    ChannelBuffer channelBuffer = chunk.getContent();
                    int bytes = channelBuffer.readableBytes();
                    if (bytes > 0) {
                        try {
                            this.queue.put((InputStream)new ChannelBufferInputStream(channelBuffer));
                        }
                        catch (InterruptedException e) {
                            log.error((Throwable)e, "Unable to put finalizing input stream into Sequence queue for url [%s]", new Object[]{url});
                            Thread.currentThread().interrupt();
                            throw Throwables.propagate((Throwable)e);
                        }
                        this.byteCount.addAndGet(bytes);
                    }
                    return clientResponse;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public ClientResponse<InputStream> done(ClientResponse<InputStream> clientResponse) {
                    long stopTime = System.currentTimeMillis();
                    log.debug("Completed queryId[%s] request to url[%s] with %,d bytes returned in %,d millis [%,f b/s].", new Object[]{query.getId(), url, this.byteCount.get(), stopTime - this.responseStartTime, (double)this.byteCount.get() / (1.0E-4 * (double)(stopTime - this.responseStartTime))});
                    DirectDruidClient.this.emitter.emit(builder.build("query/node/time", (Number)(stopTime - requestStartTime)));
                    DirectDruidClient.this.emitter.emit(builder.build("query/node/bytes", (Number)this.byteCount.get()));
                    AtomicBoolean atomicBoolean = this.done;
                    synchronized (atomicBoolean) {
                        try {
                            this.queue.put(ByteSource.empty().openStream());
                        }
                        catch (InterruptedException e) {
                            log.error((Throwable)e, "Unable to put finalizing input stream into Sequence queue for url [%s]", new Object[]{url});
                            Thread.currentThread().interrupt();
                            throw Throwables.propagate((Throwable)e);
                        }
                        catch (IOException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                        finally {
                            this.done.set(true);
                        }
                    }
                    return ClientResponse.finished((Object)clientResponse.getObj());
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void exceptionCaught(ClientResponse<InputStream> clientResponse, final Throwable e) {
                    AtomicBoolean atomicBoolean = this.done;
                    synchronized (atomicBoolean) {
                        this.done.set(true);
                        this.queue.offer(new InputStream(){

                            @Override
                            public int read() throws IOException {
                                throw new IOException(e);
                            }
                        });
                    }
                }
            };
            future = this.httpClient.go(new Request(HttpMethod.POST, new URL(url)).setContent(this.objectMapper.writeValueAsBytes(query)).setHeader("Content-Type", this.isSmile ? "application/x-jackson-smile" : "application/json"), (HttpResponseHandler)responseHandler);
            this.queryWatcher.registerQuery(query, future);
            this.openConnections.getAndIncrement();
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<InputStream>(){

                public void onSuccess(InputStream result) {
                    DirectDruidClient.this.openConnections.getAndDecrement();
                }

                public void onFailure(Throwable t) {
                    DirectDruidClient.this.openConnections.getAndDecrement();
                    if (future.isCancelled()) {
                        try {
                            StatusResponseHolder res = (StatusResponseHolder)DirectDruidClient.this.httpClient.go(new Request(HttpMethod.DELETE, new URL(cancelUrl)).setContent(DirectDruidClient.this.objectMapper.writeValueAsBytes((Object)query)).setHeader("Content-Type", DirectDruidClient.this.isSmile ? "application/x-jackson-smile" : "application/json"), (HttpResponseHandler)new StatusResponseHandler(Charsets.UTF_8)).get();
                            if (res.getStatus().getCode() >= 500) {
                                throw new RE("Error cancelling query[%s]: queriable node returned status[%d] [%s].", new Object[]{res.getStatus().getCode(), res.getStatus().getReasonPhrase()});
                            }
                        }
                        catch (IOException | InterruptedException | ExecutionException e) {
                            Throwables.propagate((Throwable)e);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        BaseSequence retVal = new BaseSequence(new BaseSequence.IteratorMaker<T, JsonParserIterator<T>>(){

            public JsonParserIterator<T> make() {
                return new JsonParserIterator(typeRef, (Future<InputStream>)future, url);
            }

            public void cleanup(JsonParserIterator<T> iterFromMake) {
                CloseQuietly.close(iterFromMake);
            }
        });
        if (!isBySegment) {
            retVal = Sequences.map((Sequence)retVal, (Function)toolChest.makePreComputeManipulatorFn(query, MetricManipulatorFns.deserializing()));
        }
        return retVal;
    }

    private class JsonParserIterator<T>
    implements Iterator<T>,
    Closeable {
        private JsonParser jp;
        private ObjectCodec objectCodec;
        private final JavaType typeRef;
        private final Future<InputStream> future;
        private final String url;

        public JsonParserIterator(JavaType typeRef, Future<InputStream> future, String url) {
            this.typeRef = typeRef;
            this.future = future;
            this.url = url;
            this.jp = null;
        }

        @Override
        public boolean hasNext() {
            this.init();
            if (this.jp.isClosed()) {
                return false;
            }
            if (this.jp.getCurrentToken() == JsonToken.END_ARRAY) {
                CloseQuietly.close((Closeable)this.jp);
                return false;
            }
            return true;
        }

        @Override
        public T next() {
            this.init();
            try {
                Object retVal = this.objectCodec.readValue(this.jp, (ResolvedType)this.typeRef);
                this.jp.nextToken();
                return (T)retVal;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void init() {
            if (this.jp == null) {
                try {
                    this.jp = DirectDruidClient.this.objectMapper.getFactory().createParser(this.future.get());
                    JsonToken nextToken = this.jp.nextToken();
                    if (nextToken == JsonToken.START_OBJECT) {
                        QueryInterruptedException cause = (QueryInterruptedException)this.jp.getCodec().readValue(this.jp, QueryInterruptedException.class);
                        if (cause.isNotKnown()) {
                            throw new QueryInterruptedException("Unknown exception", cause.getMessage(), DirectDruidClient.this.host);
                        }
                        throw new QueryInterruptedException((Throwable)cause, DirectDruidClient.this.host);
                    }
                    if (nextToken != JsonToken.START_ARRAY) {
                        throw new IAE("Next token wasn't a START_ARRAY, was[%s] from url [%s]", new Object[]{this.jp.getCurrentToken(), this.url});
                    }
                    this.jp.nextToken();
                    this.objectCodec = this.jp.getCodec();
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    throw new RE((Throwable)e, "Failure getting results from[%s] because of [%s]", new Object[]{this.url, e.getMessage()});
                }
                catch (CancellationException e) {
                    throw new QueryInterruptedException((Throwable)e, DirectDruidClient.this.host);
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (this.jp != null) {
                this.jp.close();
            }
        }
    }
}

