/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import com.metamx.common.Pair;
import com.metamx.emitter.EmittingLogger;
import io.druid.client.DruidServer;
import io.druid.client.FilteredServerInventoryView;
import io.druid.client.ServerInventoryView;
import io.druid.client.ServerView;
import io.druid.guice.ManageLifecycle;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.server.initialization.ZkPathsConfig;
import io.druid.timeline.DataSegment;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.apache.curator.framework.CuratorFramework;

@ManageLifecycle
public class SingleServerInventoryView
extends ServerInventoryView<DataSegment>
implements FilteredServerInventoryView {
    private static final EmittingLogger log = new EmittingLogger(SingleServerInventoryView.class);
    private final ConcurrentMap<ServerView.SegmentCallback, Predicate<Pair<DruidServerMetadata, DataSegment>>> segmentPredicates = new MapMaker().makeMap();
    private final Predicate<Pair<DruidServerMetadata, DataSegment>> defaultFilter;

    @Inject
    public SingleServerInventoryView(ZkPathsConfig zkPaths, CuratorFramework curator, ObjectMapper jsonMapper, Predicate<Pair<DruidServerMetadata, DataSegment>> defaultFilter) {
        super(log, zkPaths.getAnnouncementsPath(), zkPaths.getServedSegmentsPath(), curator, jsonMapper, new TypeReference<DataSegment>(){});
        Preconditions.checkNotNull(defaultFilter);
        this.defaultFilter = defaultFilter;
    }

    @Override
    protected DruidServer addInnerInventory(DruidServer container, String inventoryKey, DataSegment inventory) {
        Predicate predicate = Predicates.or(this.defaultFilter, (Predicate)Predicates.or(this.segmentPredicates.values()));
        if (predicate.apply((Object)Pair.of((Object)container.getMetadata(), (Object)inventory))) {
            this.addSingleInventory(container, inventory);
        }
        return container;
    }

    @Override
    protected DruidServer updateInnerInventory(DruidServer container, String inventoryKey, DataSegment inventory) {
        return this.addInnerInventory(container, inventoryKey, inventory);
    }

    @Override
    protected DruidServer removeInnerInventory(DruidServer container, String inventoryKey) {
        this.removeSingleInventory(container, inventoryKey);
        return container;
    }

    @Override
    public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback, Predicate<Pair<DruidServerMetadata, DataSegment>> filter) {
        FilteringSegmentCallback filteringCallback = new FilteringSegmentCallback(callback, filter);
        this.segmentPredicates.put(filteringCallback, filter);
        this.registerSegmentCallback(exec, filteringCallback);
    }

    @Override
    protected void segmentCallbackRemoved(ServerView.SegmentCallback callback) {
        this.segmentPredicates.remove(callback);
    }

    static class FilteringSegmentCallback
    implements ServerView.SegmentCallback {
        private final ServerView.SegmentCallback callback;
        private final Predicate<Pair<DruidServerMetadata, DataSegment>> filter;

        FilteringSegmentCallback(ServerView.SegmentCallback callback, Predicate<Pair<DruidServerMetadata, DataSegment>> filter) {
            this.callback = callback;
            this.filter = filter;
        }

        @Override
        public ServerView.CallbackAction segmentAdded(DruidServerMetadata server, DataSegment segment) {
            ServerView.CallbackAction action = this.filter.apply((Object)Pair.of((Object)server, (Object)segment)) ? this.callback.segmentAdded(server, segment) : ServerView.CallbackAction.CONTINUE;
            return action;
        }

        @Override
        public ServerView.CallbackAction segmentRemoved(DruidServerMetadata server, DataSegment segment) {
            ServerView.CallbackAction action = this.filter.apply((Object)Pair.of((Object)server, (Object)segment)) ? this.callback.segmentRemoved(server, segment) : ServerView.CallbackAction.CONTINUE;
            return action;
        }

        @Override
        public ServerView.CallbackAction segmentViewInitialized() {
            return this.callback.segmentViewInitialized();
        }
    }
}

