/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.selector;

import com.google.common.collect.Sets;
import com.metamx.emitter.EmittingLogger;
import io.druid.client.selector.DiscoverySelector;
import io.druid.client.selector.QueryableDruidServer;
import io.druid.client.selector.TierSelectorStrategy;
import io.druid.timeline.DataSegment;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;

public class ServerSelector
implements DiscoverySelector<QueryableDruidServer> {
    private static final EmittingLogger log = new EmittingLogger(ServerSelector.class);
    private final Set<QueryableDruidServer> servers = Sets.newHashSet();
    private final TierSelectorStrategy strategy;
    private final AtomicReference<DataSegment> segment;

    public ServerSelector(DataSegment segment, TierSelectorStrategy strategy) {
        this.segment = new AtomicReference<DataSegment>(segment);
        this.strategy = strategy;
    }

    public DataSegment getSegment() {
        return this.segment.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerAndUpdateSegment(QueryableDruidServer server, DataSegment segment) {
        ServerSelector serverSelector = this;
        synchronized (serverSelector) {
            this.segment.set(segment);
            this.servers.add(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeServer(QueryableDruidServer server) {
        ServerSelector serverSelector = this;
        synchronized (serverSelector) {
            return this.servers.remove(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        ServerSelector serverSelector = this;
        synchronized (serverSelector) {
            return this.servers.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryableDruidServer pick() {
        ServerSelector serverSelector = this;
        synchronized (serverSelector) {
            TreeMap<Integer, Set<QueryableDruidServer>> prioritizedServers = new TreeMap<Integer, Set<QueryableDruidServer>>(this.strategy.getComparator());
            for (QueryableDruidServer server : this.servers) {
                HashSet theServers = prioritizedServers.get(server.getServer().getPriority());
                if (theServers == null) {
                    theServers = Sets.newHashSet();
                    prioritizedServers.put(server.getServer().getPriority(), theServers);
                }
                theServers.add(server);
            }
            return this.strategy.pick(prioritizedServers, this.segment.get());
        }
    }
}

