/*
 * Decompiled with CFR 0.152.
 */
package io.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.metamx.common.MapUtils;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.EmittingLogger;
import io.druid.client.DruidDataSource;
import io.druid.concurrent.Execs;
import io.druid.guice.ManageLifecycle;
import io.druid.metadata.MetadataSegmentManager;
import io.druid.metadata.MetadataSegmentManagerConfig;
import io.druid.metadata.MetadataStorageTablesConfig;
import io.druid.metadata.SQLMetadataConnector;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.PartitionChunk;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.skife.jdbi.v2.BaseResultSetMapper;
import org.skife.jdbi.v2.Batch;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.ByteArrayMapper;

@ManageLifecycle
public class SQLMetadataSegmentManager
implements MetadataSegmentManager {
    private static final EmittingLogger log = new EmittingLogger(SQLMetadataSegmentManager.class);
    private final Object lock = new Object();
    private final ObjectMapper jsonMapper;
    private final Supplier<MetadataSegmentManagerConfig> config;
    private final Supplier<MetadataStorageTablesConfig> dbTables;
    private final AtomicReference<ConcurrentHashMap<String, DruidDataSource>> dataSources;
    private final SQLMetadataConnector connector;
    private volatile ListeningScheduledExecutorService exec = null;
    private volatile ListenableFuture<?> future = null;
    private volatile boolean started = false;

    @Inject
    public SQLMetadataSegmentManager(ObjectMapper jsonMapper, Supplier<MetadataSegmentManagerConfig> config, Supplier<MetadataStorageTablesConfig> dbTables, SQLMetadataConnector connector) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.dbTables = dbTables;
        this.dataSources = new AtomicReference(new ConcurrentHashMap());
        this.connector = connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.exec = MoreExecutors.listeningDecorator((ScheduledExecutorService)Execs.scheduledSingleThreaded((String)"DatabaseSegmentManager-Exec--%d"));
            Duration delay = ((MetadataSegmentManagerConfig)this.config.get()).getPollDuration().toStandardDuration();
            this.future = this.exec.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        SQLMetadataSegmentManager.this.poll();
                    }
                    catch (Exception e) {
                        log.makeAlert((Throwable)e, "uncaught exception in segment manager polling thread", new Object[0]).emit();
                    }
                }
            }, 0L, delay.getMillis(), TimeUnit.MILLISECONDS);
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
            this.dataSources.set(new ConcurrentHashMap());
            this.future.cancel(false);
            this.future = null;
            this.exec.shutdownNow();
            this.exec = null;
        }
    }

    private <T> T inReadOnlyTransaction(final TransactionCallback<T> callback) {
        return (T)this.connector.getDBI().withHandle(new HandleCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T withHandle(Handle handle) throws Exception {
                Connection connection = handle.getConnection();
                boolean readOnly = connection.isReadOnly();
                connection.setReadOnly(true);
                try {
                    Object object = handle.inTransaction(callback);
                    return object;
                }
                finally {
                    try {
                        connection.setReadOnly(readOnly);
                    }
                    catch (SQLException e) {
                        log.error((Throwable)e, "Unable to reset connection read-only state", new Object[0]);
                    }
                }
            }
        });
    }

    @Override
    public boolean enableDatasource(final String ds) {
        try {
            DBI dbi = this.connector.getDBI();
            VersionedIntervalTimeline<String, DataSegment> segmentTimeline = this.inReadOnlyTransaction(new TransactionCallback<VersionedIntervalTimeline<String, DataSegment>>(){

                public VersionedIntervalTimeline<String, DataSegment> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                    return (VersionedIntervalTimeline)((Query)handle.createQuery(String.format("SELECT payload FROM %s WHERE dataSource = :dataSource", SQLMetadataSegmentManager.this.getSegmentsTable())).setFetchSize(SQLMetadataSegmentManager.this.connector.getStreamingFetchSize()).bind("dataSource", ds)).map((ResultSetMapper)ByteArrayMapper.FIRST).fold((Object)new VersionedIntervalTimeline((Comparator)Ordering.natural()), (Folder3)new Folder3<VersionedIntervalTimeline<String, DataSegment>, byte[]>(){

                        public VersionedIntervalTimeline<String, DataSegment> fold(VersionedIntervalTimeline<String, DataSegment> timeline, byte[] payload, FoldController foldController, StatementContext statementContext) throws SQLException {
                            try {
                                DataSegment segment = (DataSegment)SQLMetadataSegmentManager.this.jsonMapper.readValue(payload, DataSegment.class);
                                timeline.add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)segment));
                                return timeline;
                            }
                            catch (Exception e) {
                                throw new SQLException(e.toString());
                            }
                        }
                    });
                }
            });
            final ArrayList segments = Lists.newArrayList();
            for (TimelineObjectHolder objectHolder : segmentTimeline.lookup(new Interval((Object)"0000-01-01/3000-01-01"))) {
                for (PartitionChunk partitionChunk : objectHolder.getObject()) {
                    segments.add(partitionChunk.getObject());
                }
            }
            if (segments.isEmpty()) {
                log.warn("No segments found in the database!", new Object[0]);
                return false;
            }
            dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    Batch batch = handle.createBatch();
                    for (DataSegment segment : segments) {
                        batch.add(String.format("UPDATE %s SET used=true WHERE id = '%s'", SQLMetadataSegmentManager.this.getSegmentsTable(), segment.getIdentifier()));
                    }
                    batch.execute();
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception enabling datasource %s", new Object[]{ds});
            return false;
        }
        return true;
    }

    @Override
    public boolean enableSegment(final String segmentId) {
        try {
            this.connector.getDBI().withHandle((HandleCallback)new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    ((Update)handle.createStatement(String.format("UPDATE %s SET used=true WHERE id = :id", SQLMetadataSegmentManager.this.getSegmentsTable())).bind("id", segmentId)).execute();
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception enabling segment %s", new Object[]{segmentId});
            return false;
        }
        return true;
    }

    @Override
    public boolean removeDatasource(final String ds) {
        try {
            ConcurrentHashMap<String, DruidDataSource> dataSourceMap = this.dataSources.get();
            if (!dataSourceMap.containsKey(ds)) {
                log.warn("Cannot delete datasource %s, does not exist", new Object[]{ds});
                return false;
            }
            this.connector.getDBI().withHandle((HandleCallback)new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    ((Update)handle.createStatement(String.format("UPDATE %s SET used=false WHERE dataSource = :dataSource", SQLMetadataSegmentManager.this.getSegmentsTable())).bind("dataSource", ds)).execute();
                    return null;
                }
            });
            dataSourceMap.remove(ds);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error removing datasource %s", new Object[]{ds});
            return false;
        }
        return true;
    }

    @Override
    public boolean removeSegment(String ds, final String segmentID) {
        try {
            this.connector.getDBI().withHandle((HandleCallback)new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    ((Update)handle.createStatement(String.format("UPDATE %s SET used=false WHERE id = :segmentID", SQLMetadataSegmentManager.this.getSegmentsTable())).bind("segmentID", segmentID)).execute();
                    return null;
                }
            });
            ConcurrentHashMap<String, DruidDataSource> dataSourceMap = this.dataSources.get();
            if (!dataSourceMap.containsKey(ds)) {
                log.warn("Cannot find datasource %s", new Object[]{ds});
                return false;
            }
            DruidDataSource dataSource = dataSourceMap.get(ds);
            dataSource.removePartition(segmentID);
            if (dataSource.isEmpty()) {
                dataSourceMap.remove(ds);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, e.toString(), new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public DruidDataSource getInventoryValue(String key) {
        return this.dataSources.get().get(key);
    }

    @Override
    public Collection<DruidDataSource> getInventory() {
        return this.dataSources.get().values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getAllDatasourceNames() {
        Object object = this.lock;
        synchronized (object) {
            return (Collection)this.connector.getDBI().withHandle((HandleCallback)new HandleCallback<List<String>>(){

                public List<String> withHandle(Handle handle) throws Exception {
                    return (List)handle.createQuery(String.format("SELECT DISTINCT(datasource) FROM %s", SQLMetadataSegmentManager.this.getSegmentsTable())).fold((Object)Lists.newArrayList(), (Folder3)new Folder3<ArrayList<String>, Map<String, Object>>(){

                        public ArrayList<String> fold(ArrayList<String> druidDataSources, Map<String, Object> stringObjectMap, FoldController foldController, StatementContext statementContext) throws SQLException {
                            druidDataSources.add(MapUtils.getString(stringObjectMap, (String)"datasource"));
                            return druidDataSources;
                        }
                    });
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void poll() {
        try {
            if (!this.started) {
                return;
            }
            ConcurrentHashMap<String, DruidDataSource> newDataSources = new ConcurrentHashMap<String, DruidDataSource>();
            log.debug("Starting polling of segment table", new Object[0]);
            List<DataSegment> segments = this.inReadOnlyTransaction(new TransactionCallback<List<DataSegment>>(){

                public List<DataSegment> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                    return handle.createQuery(String.format("SELECT payload FROM %s WHERE used=true", SQLMetadataSegmentManager.this.getSegmentsTable())).setFetchSize(SQLMetadataSegmentManager.this.connector.getStreamingFetchSize()).map((ResultSetMapper)new ResultSetMapper<DataSegment>(){

                        public DataSegment map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                            try {
                                return (DataSegment)SQLMetadataSegmentManager.this.jsonMapper.readValue(r.getBytes("payload"), DataSegment.class);
                            }
                            catch (IOException e) {
                                log.makeAlert((Throwable)e, "Failed to read segment from db.", new Object[0]);
                                return null;
                            }
                        }
                    }).list();
                }
            });
            if (segments == null || segments.isEmpty()) {
                log.warn("No segments found in the database!", new Object[0]);
                return;
            }
            Collection segmentsFinal = Collections2.filter(segments, (Predicate)Predicates.notNull());
            log.info("Polled and found %,d segments in the database", new Object[]{segments.size()});
            for (DataSegment segment : segmentsFinal) {
                DruidDataSource shouldBeNull;
                String datasourceName = segment.getDataSource();
                DruidDataSource dataSource = (DruidDataSource)newDataSources.get(datasourceName);
                if (dataSource == null && (shouldBeNull = newDataSources.put(datasourceName, dataSource = new DruidDataSource(datasourceName, (Map<String, String>)ImmutableMap.of((Object)"created", (Object)new DateTime().toString())))) != null) {
                    log.warn("Just put key[%s] into dataSources and what was there wasn't null!?  It was[%s]", new Object[]{datasourceName, shouldBeNull});
                }
                if (dataSource.getSegments().contains(segment)) continue;
                dataSource.addSegment(segment.getIdentifier(), segment);
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.started) {
                    this.dataSources.set(newDataSources);
                }
            }
        }
        catch (Exception e) {
            log.makeAlert((Throwable)e, "Problem polling DB.", new Object[0]).emit();
        }
    }

    private String getSegmentsTable() {
        return ((MetadataStorageTablesConfig)this.dbTables.get()).getSegmentsTable();
    }

    @Override
    public List<Interval> getUnusedSegmentIntervals(final String dataSource, final Interval interval, final int limit) {
        return this.inReadOnlyTransaction(new TransactionCallback<List<Interval>>(){

            public List<Interval> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                ResultIterator iter = ((Query)((Query)((Query)handle.createQuery(String.format("SELECT start, \"end\" FROM %s WHERE dataSource = :dataSource and start >= :start and \"end\" <= :end and used = false ORDER BY start, \"end\"", SQLMetadataSegmentManager.this.getSegmentsTable())).setFetchSize(SQLMetadataSegmentManager.this.connector.getStreamingFetchSize()).bind("dataSource", dataSource)).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString())).map((ResultSetMapper)new BaseResultSetMapper<Interval>(){

                    protected Interval mapInternal(int index, Map<String, Object> row) {
                        return new Interval((ReadableInstant)DateTime.parse((String)((String)row.get("start"))), (ReadableInstant)DateTime.parse((String)((String)row.get("end"))));
                    }
                }).iterator();
                ArrayList result = Lists.newArrayListWithCapacity((int)limit);
                for (int i = 0; i < limit && iter.hasNext(); ++i) {
                    try {
                        result.add(iter.next());
                        continue;
                    }
                    catch (Exception e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
                return result;
            }
        });
    }
}

