/*
 * Decompiled with CFR 0.152.
 */
package io.druid.offheap;

import com.google.common.base.Supplier;
import com.metamx.common.logger.Logger;
import io.druid.collections.StupidPool;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;

public class OffheapBufferPool
extends StupidPool<ByteBuffer> {
    private static final Logger log = new Logger(OffheapBufferPool.class);

    public OffheapBufferPool(final int computationBufferSize, int cacheMaxCount) {
        super((Supplier)new Supplier<ByteBuffer>(){
            final AtomicLong count = new AtomicLong(0L);

            public ByteBuffer get() {
                log.info("Allocating new intermediate processing buffer[%,d] of size[%,d]", new Object[]{this.count.getAndIncrement(), computationBufferSize});
                return ByteBuffer.allocateDirect(computationBufferSize);
            }
        }, cacheMaxCount);
    }
}

