/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime;

import com.google.common.base.Throwables;
import com.metamx.common.Pair;
import io.druid.segment.IncrementalIndexSegment;
import io.druid.segment.ReferenceCountingSegment;
import io.druid.segment.Segment;
import io.druid.segment.incremental.IncrementalIndex;
import java.io.Closeable;
import java.io.IOException;

public class FireHydrant {
    private final int count;
    private volatile IncrementalIndex index;
    private volatile ReferenceCountingSegment adapter;
    private Object swapLock = new Object();

    public FireHydrant(IncrementalIndex index, int count, String segmentIdentifier) {
        this.index = index;
        this.adapter = new ReferenceCountingSegment((Segment)new IncrementalIndexSegment(index, segmentIdentifier));
        this.count = count;
    }

    public FireHydrant(Segment adapter, int count) {
        this.index = null;
        this.adapter = new ReferenceCountingSegment(adapter);
        this.count = count;
    }

    public IncrementalIndex getIndex() {
        return this.index;
    }

    public Segment getSegment() {
        return this.adapter;
    }

    public int getCount() {
        return this.count;
    }

    public boolean hasSwapped() {
        return this.index == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapSegment(Segment adapter) {
        Object object = this.swapLock;
        synchronized (object) {
            if (this.adapter != null) {
                try {
                    this.adapter.close();
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            this.adapter = new ReferenceCountingSegment(adapter);
            this.index = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Segment, Closeable> getAndIncrementSegment() {
        Object object = this.swapLock;
        synchronized (object) {
            Closeable closeable = this.adapter.increment();
            return new Pair((Object)this.adapter, (Object)closeable);
        }
    }

    public String toString() {
        return "FireHydrant{index=" + this.index + ", queryable=" + this.adapter + ", count=" + this.count + '}';
    }
}

