/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.Pair;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.emitter.EmittingLogger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.client.CachingQueryRunner;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheConfig;
import io.druid.common.guava.ThreadRenamingCallable;
import io.druid.concurrent.Execs;
import io.druid.data.input.Committer;
import io.druid.data.input.InputRow;
import io.druid.query.BySegmentQueryRunner;
import io.druid.query.MetricsEmittingQueryRunner;
import io.druid.query.NoopQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.query.QueryRunnerHelper;
import io.druid.query.QueryToolChest;
import io.druid.query.ReportTimelineMissingSegmentQueryRunner;
import io.druid.query.SegmentDescriptor;
import io.druid.query.spec.SpecificSegmentQueryRunner;
import io.druid.query.spec.SpecificSegmentSpec;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.IndexSpec;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.incremental.IndexSizeExceededException;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.FireHydrant;
import io.druid.segment.realtime.appenderator.Appenderator;
import io.druid.segment.realtime.appenderator.AppenderatorConfig;
import io.druid.segment.realtime.appenderator.Committed;
import io.druid.segment.realtime.appenderator.SegmentIdentifier;
import io.druid.segment.realtime.appenderator.SegmentNotWritableException;
import io.druid.segment.realtime.appenderator.SegmentsAndMetadata;
import io.druid.segment.realtime.plumber.Sink;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.PartitionChunk;
import io.druid.timeline.partition.PartitionHolder;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadablePeriod;

public class AppenderatorImpl
implements Appenderator {
    private static final EmittingLogger log = new EmittingLogger(AppenderatorImpl.class);
    private static final int WARN_DELAY = 1000;
    private static final String IDENTIFIER_FILE_NAME = "identifier.json";
    private static final String CONTEXT_SKIP_INCREMENTAL_SEGMENT = "skipIncrementalSegment";
    private final DataSchema schema;
    private final AppenderatorConfig tuningConfig;
    private final FireDepartmentMetrics metrics;
    private final DataSegmentPusher dataSegmentPusher;
    private final ObjectMapper objectMapper;
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final ServiceEmitter emitter;
    private final ExecutorService queryExecutorService;
    private final IndexIO indexIO;
    private final IndexMerger indexMerger;
    private final Cache cache;
    private final CacheConfig cacheConfig;
    private final Map<SegmentIdentifier, Sink> sinks = Maps.newConcurrentMap();
    private final Set<SegmentIdentifier> droppingSinks = Sets.newConcurrentHashSet();
    private final VersionedIntervalTimeline<String, Sink> sinkTimeline = new VersionedIntervalTimeline(String.CASE_INSENSITIVE_ORDER);
    private volatile ListeningExecutorService persistExecutor = null;
    private volatile ListeningExecutorService mergeExecutor = null;
    private volatile long nextFlush;
    private volatile FileLock basePersistDirLock = null;
    private volatile FileChannel basePersistDirLockChannel = null;

    public AppenderatorImpl(DataSchema schema, AppenderatorConfig tuningConfig, FireDepartmentMetrics metrics, DataSegmentPusher dataSegmentPusher, ObjectMapper objectMapper, QueryRunnerFactoryConglomerate conglomerate, DataSegmentAnnouncer segmentAnnouncer, ServiceEmitter emitter, ExecutorService queryExecutorService, IndexIO indexIO, IndexMerger indexMerger, Cache cache, CacheConfig cacheConfig) {
        this.schema = (DataSchema)Preconditions.checkNotNull((Object)schema, (Object)"schema");
        this.tuningConfig = (AppenderatorConfig)Preconditions.checkNotNull((Object)tuningConfig, (Object)"tuningConfig");
        this.metrics = (FireDepartmentMetrics)Preconditions.checkNotNull((Object)metrics, (Object)"metrics");
        this.dataSegmentPusher = (DataSegmentPusher)Preconditions.checkNotNull((Object)dataSegmentPusher, (Object)"dataSegmentPusher");
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper, (Object)"objectMapper");
        this.conglomerate = conglomerate;
        this.segmentAnnouncer = segmentAnnouncer;
        this.emitter = emitter;
        this.queryExecutorService = queryExecutorService;
        this.indexIO = indexIO;
        this.indexMerger = indexMerger;
        this.cache = cache;
        this.cacheConfig = cacheConfig;
        if (conglomerate != null) {
            Preconditions.checkNotNull((Object)segmentAnnouncer, (Object)"segmentAnnouncer");
            Preconditions.checkNotNull((Object)emitter, (Object)"emitter");
            Preconditions.checkNotNull((Object)queryExecutorService, (Object)"queryExecutorService");
            Preconditions.checkNotNull((Object)cache, (Object)"cache");
            Preconditions.checkNotNull((Object)cacheConfig, (Object)"cacheConfig");
            if (!cache.isLocal()) {
                log.error("Configured cache is not local, caching will not be enabled", new Object[0]);
            }
        }
        log.info("Creating appenderator for dataSource[%s]", new Object[]{schema.getDataSource()});
    }

    @Override
    public String getDataSource() {
        return this.schema.getDataSource();
    }

    @Override
    public Object startJob() {
        this.tuningConfig.getBasePersistDirectory().mkdirs();
        this.lockBasePersistDirectory();
        Object retVal = this.bootstrapSinksFromDisk();
        this.initializeExecutors();
        this.resetNextFlush();
        return retVal;
    }

    @Override
    public int add(SegmentIdentifier identifier, InputRow row, Supplier<Committer> committerSupplier) throws IndexSizeExceededException, SegmentNotWritableException {
        int sinkRetVal;
        if (!identifier.getDataSource().equals(this.schema.getDataSource())) {
            throw new IAE("Expected dataSource[%s] but was asked to insert row for dataSource[%s]?!", new Object[]{this.schema.getDataSource(), identifier.getDataSource()});
        }
        Sink sink = this.getOrCreateSink(identifier);
        try {
            sinkRetVal = sink.add(row);
        }
        catch (IndexSizeExceededException e) {
            this.persistAll((Committer)committerSupplier.get());
            sinkRetVal = sink.add(row);
        }
        if (!sink.canAppendRow() || System.currentTimeMillis() > this.nextFlush) {
            this.persistAll((Committer)committerSupplier.get());
        }
        if (sinkRetVal < 0) {
            throw new SegmentNotWritableException("Attempt to add row to swapped-out sink for segment[%s].", identifier);
        }
        return sink.getNumRows();
    }

    @Override
    public List<SegmentIdentifier> getSegments() {
        return ImmutableList.copyOf(this.sinks.keySet());
    }

    @Override
    public int getRowCount(SegmentIdentifier identifier) {
        Sink sink = this.sinks.get(identifier);
        if (sink == null) {
            throw new ISE("No such sink: %s", new Object[]{identifier});
        }
        return sink.getNumRows();
    }

    private Sink getOrCreateSink(SegmentIdentifier identifier) {
        Sink retVal = this.sinks.get(identifier);
        if (retVal == null) {
            retVal = new Sink(identifier.getInterval(), this.schema, identifier.getShardSpec(), identifier.getVersion(), this.tuningConfig.getMaxRowsInMemory(), this.tuningConfig.isReportParseExceptions());
            try {
                this.segmentAnnouncer.announceSegment(retVal.getSegment());
            }
            catch (IOException e) {
                log.makeAlert((Throwable)e, "Failed to announce new segment[%s]", new Object[]{this.schema.getDataSource()}).addData("interval", (Object)retVal.getInterval()).emit();
            }
            this.sinks.put(identifier, retVal);
            this.sinkTimeline.add(retVal.getInterval(), (Object)retVal.getVersion(), identifier.getShardSpec().createChunk((Object)retVal));
        }
        return retVal;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        if (this.conglomerate == null) {
            throw new IllegalStateException("Don't query me, bro.");
        }
        FunctionalIterable specs = FunctionalIterable.create(intervals).transformCat((Function)new Function<Interval, Iterable<TimelineObjectHolder<String, Sink>>>(){

            public Iterable<TimelineObjectHolder<String, Sink>> apply(Interval interval) {
                return AppenderatorImpl.this.sinkTimeline.lookup(interval);
            }
        }).transformCat((Function)new Function<TimelineObjectHolder<String, Sink>, Iterable<SegmentDescriptor>>(){

            public Iterable<SegmentDescriptor> apply(final TimelineObjectHolder<String, Sink> holder) {
                return FunctionalIterable.create((Iterable)holder.getObject()).transform((Function)new Function<PartitionChunk<Sink>, SegmentDescriptor>(){

                    public SegmentDescriptor apply(PartitionChunk<Sink> chunk) {
                        return new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), chunk.getChunkNumber());
                    }
                });
            }
        });
        return this.getQueryRunnerForSegments(query, (Iterable<SegmentDescriptor>)specs);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(final Query<T> query, Iterable<SegmentDescriptor> specs) {
        if (this.conglomerate == null) {
            throw new IllegalStateException("Don't query me, bro.");
        }
        if (!query.getDataSource().getNames().contains(this.getDataSource())) {
            log.makeAlert("Received query for unknown dataSource", new Object[0]).addData("dataSource", (Object)query.getDataSource()).emit();
            return new NoopQueryRunner();
        }
        final QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            throw new ISE("Unknown query type[%s].", new Object[]{query.getClass()});
        }
        final QueryToolChest toolchest = factory.getToolchest();
        final Function builderFn = new Function<Query<T>, ServiceMetricEvent.Builder>(){

            public ServiceMetricEvent.Builder apply(@Nullable Query<T> input) {
                return toolchest.makeMetricBuilder(query);
            }
        };
        final boolean skipIncrementalSegment = (Boolean)query.getContextValue(CONTEXT_SKIP_INCREMENTAL_SEGMENT, (Object)false);
        return toolchest.mergeResults(factory.mergeRunners(this.queryExecutorService, (Iterable)FunctionalIterable.create(specs).transform(new Function<SegmentDescriptor, QueryRunner<T>>(){

            public QueryRunner<T> apply(final SegmentDescriptor descriptor) {
                PartitionHolder holder = AppenderatorImpl.this.sinkTimeline.findEntry(descriptor.getInterval(), (Object)descriptor.getVersion());
                if (holder == null) {
                    return new ReportTimelineMissingSegmentQueryRunner(descriptor);
                }
                PartitionChunk chunk = holder.getChunk(descriptor.getPartitionNumber());
                if (chunk == null) {
                    return new ReportTimelineMissingSegmentQueryRunner(descriptor);
                }
                Sink theSink = (Sink)chunk.getObject();
                return new SpecificSegmentQueryRunner((QueryRunner)new MetricsEmittingQueryRunner(AppenderatorImpl.this.emitter, builderFn, (QueryRunner)new BySegmentQueryRunner(theSink.getSegment().getIdentifier(), descriptor.getInterval().getStart(), factory.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), Iterables.transform((Iterable)theSink, (Function)new Function<FireHydrant, QueryRunner<T>>(){

                    public QueryRunner<T> apply(FireHydrant hydrant) {
                        boolean hydrantDefinitelySwapped = hydrant.hasSwapped();
                        if (skipIncrementalSegment && !hydrantDefinitelySwapped) {
                            return new NoopQueryRunner();
                        }
                        Pair<Segment, Closeable> segment = hydrant.getAndIncrementSegment();
                        try {
                            QueryRunner baseRunner = QueryRunnerHelper.makeClosingQueryRunner((QueryRunner)factory.createRunner((Segment)segment.lhs), (Closeable)((Closeable)segment.rhs));
                            if (hydrantDefinitelySwapped && AppenderatorImpl.this.cache.isLocal()) {
                                return new CachingQueryRunner(AppenderatorImpl.makeHydrantCacheIdentifier(hydrant, (Segment)segment.lhs), descriptor, AppenderatorImpl.this.objectMapper, AppenderatorImpl.this.cache, toolchest, baseRunner, (ExecutorService)MoreExecutors.sameThreadExecutor(), AppenderatorImpl.this.cacheConfig);
                            }
                            return baseRunner;
                        }
                        catch (RuntimeException e) {
                            CloseQuietly.close((Closeable)((Closeable)segment.rhs));
                            throw e;
                        }
                    }
                })))).withWaitMeasuredFromNow(), new SpecificSegmentSpec(descriptor));
            }
        })));
    }

    @Override
    public void clear() throws InterruptedException {
        try {
            ListenableFuture uncommitFuture = this.persistExecutor.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    AppenderatorImpl.this.objectMapper.writeValue(AppenderatorImpl.this.computeCommitFile(), (Object)Committed.nil());
                    return null;
                }
            });
            uncommitFuture.get();
            ArrayList futures = Lists.newArrayList();
            for (Map.Entry<SegmentIdentifier, Sink> entry : this.sinks.entrySet()) {
                futures.add(this.abandonSegment(entry.getKey(), entry.getValue(), true));
            }
            Futures.allAsList((Iterable)futures).get();
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public ListenableFuture<?> drop(SegmentIdentifier identifier) {
        Sink sink = this.sinks.get(identifier);
        if (sink != null) {
            return this.abandonSegment(identifier, sink, true);
        }
        return Futures.immediateFuture(null);
    }

    @Override
    public ListenableFuture<Object> persistAll(final Committer committer) {
        final HashMap commitHydrants = Maps.newHashMap();
        final ArrayList indexesToPersist = Lists.newArrayList();
        Set<SegmentIdentifier> identifiers = this.sinks.keySet();
        for (SegmentIdentifier identifier : identifiers) {
            Sink sink = this.sinks.get(identifier);
            ArrayList hydrants = Lists.newArrayList((Iterable)sink);
            commitHydrants.put(identifier, hydrants.size());
            int limit = sink.isWritable() ? hydrants.size() - 1 : hydrants.size();
            for (FireHydrant hydrant : hydrants.subList(0, limit)) {
                if (hydrant.hasSwapped()) continue;
                log.info("Hydrant[%s] hasn't persisted yet, persisting. Segment[%s]", new Object[]{hydrant, identifier});
                indexesToPersist.add(Pair.of((Object)hydrant, (Object)identifier));
            }
            if (!sink.swappable()) continue;
            indexesToPersist.add(Pair.of((Object)sink.swap(), (Object)identifier));
        }
        log.info("Submitting persist runnable for dataSource[%s]", new Object[]{this.schema.getDataSource()});
        String threadName = String.format("%s-incremental-persist", this.schema.getDataSource());
        final Object commitMetadata = committer.getMetadata();
        Stopwatch runExecStopwatch = Stopwatch.createStarted();
        final Stopwatch persistStopwatch = Stopwatch.createStarted();
        ListenableFuture future = this.persistExecutor.submit((Callable)new ThreadRenamingCallable<Object>(threadName){

            public Object doCall() {
                try {
                    for (Pair pair : indexesToPersist) {
                        AppenderatorImpl.this.metrics.incrementRowOutputCount(AppenderatorImpl.this.persistHydrant((FireHydrant)pair.lhs, (SegmentIdentifier)pair.rhs));
                    }
                    log.info("Committing metadata[%s] for sinks[%s].", new Object[]{commitMetadata, Joiner.on((String)", ").join(Iterables.transform(commitHydrants.entrySet(), (Function)new Function<Map.Entry<SegmentIdentifier, Integer>, String>(){

                        public String apply(Map.Entry<SegmentIdentifier, Integer> entry) {
                            return String.format("%s:%d", entry.getKey().getIdentifierAsString(), entry.getValue());
                        }
                    }))});
                    committer.run();
                    AppenderatorImpl.this.objectMapper.writeValue(AppenderatorImpl.this.computeCommitFile(), (Object)Committed.create(commitHydrants, commitMetadata));
                    Object object = commitMetadata;
                    return object;
                }
                catch (Exception e) {
                    AppenderatorImpl.this.metrics.incrementFailedPersists();
                    throw Throwables.propagate((Throwable)e);
                }
                finally {
                    AppenderatorImpl.this.metrics.incrementNumPersists();
                    AppenderatorImpl.this.metrics.incrementPersistTimeMillis(persistStopwatch.elapsed(TimeUnit.MILLISECONDS));
                    persistStopwatch.stop();
                }
            }
        });
        long startDelay = runExecStopwatch.elapsed(TimeUnit.MILLISECONDS);
        this.metrics.incrementPersistBackPressureMillis(startDelay);
        if (startDelay > 1000L) {
            log.warn("Ingestion was throttled for [%,d] millis because persists were pending.", new Object[]{startDelay});
        }
        runExecStopwatch.stop();
        this.resetNextFlush();
        return future;
    }

    @Override
    public ListenableFuture<SegmentsAndMetadata> push(List<SegmentIdentifier> identifiers, Committer committer) {
        final HashMap theSinks = Maps.newHashMap();
        for (SegmentIdentifier identifier : identifiers) {
            Sink sink = this.sinks.get(identifier);
            if (sink == null) {
                throw new NullPointerException("No sink for identifier: " + identifier);
            }
            theSinks.put(identifier, sink);
            sink.finishWriting();
        }
        return Futures.transform(this.persistAll(committer), (Function)new Function<Object, SegmentsAndMetadata>(){

            public SegmentsAndMetadata apply(Object commitMetadata) {
                ArrayList dataSegments = Lists.newArrayList();
                for (Map.Entry entry : theSinks.entrySet()) {
                    if (AppenderatorImpl.this.droppingSinks.contains(entry.getKey())) {
                        log.info("Skipping push of currently-dropping sink[%s]", new Object[]{entry.getKey()});
                        continue;
                    }
                    DataSegment dataSegment = AppenderatorImpl.this.mergeAndPush((SegmentIdentifier)entry.getKey(), (Sink)entry.getValue());
                    if (dataSegment != null) {
                        dataSegments.add(dataSegment);
                        continue;
                    }
                    log.warn("mergeAndPush[%s] returned null, skipping.", new Object[]{entry.getKey()});
                }
                return new SegmentsAndMetadata(dataSegments, commitMetadata);
            }
        }, (Executor)this.mergeExecutor);
    }

    private ListenableFuture<?> mergeBarrier() {
        return this.mergeExecutor.submit(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSegment mergeAndPush(SegmentIdentifier identifier, Sink sink) {
        if (this.sinks.get(identifier) != sink) {
            log.warn("Sink for segment[%s] no longer valid, bailing out of mergeAndPush.", new Object[]{identifier});
            return null;
        }
        File persistDir = this.computePersistDir(identifier);
        File mergedTarget = new File(persistDir, "merged");
        File descriptorFile = this.computeDescriptorFile(identifier);
        for (Object hydrant : sink) {
            if (sink.isWritable()) {
                throw new ISE("WTF?! Expected sink to be no longer writable before mergeAndPush. Segment[%s].", new Object[]{identifier});
            }
            FireHydrant fireHydrant = hydrant;
            synchronized (fireHydrant) {
                if (!((FireHydrant)hydrant).hasSwapped()) {
                    throw new ISE("WTF?! Expected sink to be fully persisted before mergeAndPush. Segment[%s].", new Object[]{identifier});
                }
            }
        }
        try {
            Segment segment;
            if (descriptorFile.exists()) {
                log.info("Segment[%s] already pushed.", new Object[]{identifier});
                return (DataSegment)this.objectMapper.readValue(descriptorFile, DataSegment.class);
            }
            log.info("Pushing merged index for segment[%s].", new Object[]{identifier});
            this.removeDirectory(mergedTarget);
            if (mergedTarget.exists()) {
                throw new ISE("Merged target[%s] exists after removing?!", new Object[]{mergedTarget});
            }
            ArrayList indexes = Lists.newArrayList();
            for (FireHydrant fireHydrant : sink) {
                segment = fireHydrant.getSegment();
                QueryableIndex queryableIndex = segment.asQueryableIndex();
                log.info("Adding hydrant[%s]", new Object[]{fireHydrant});
                indexes.add(queryableIndex);
            }
            File mergedFile = this.indexMerger.mergeQueryableIndex((List)indexes, this.schema.getAggregators(), mergedTarget, this.tuningConfig.getIndexSpec());
            QueryableIndex index = this.indexIO.loadIndex(mergedFile);
            segment = this.dataSegmentPusher.push(mergedFile, sink.getSegment().withDimensions((List)Lists.newArrayList((Iterable)index.getAvailableDimensions())));
            this.objectMapper.writeValue(descriptorFile, (Object)segment);
            log.info("Pushed merged index for segment[%s], descriptor is: %s", new Object[]{identifier, segment});
            return segment;
        }
        catch (Exception e) {
            this.metrics.incrementFailedHandoffs();
            log.warn((Throwable)e, "Failed to push merged index for segment[%s].", new Object[]{identifier});
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void close() {
        log.info("Shutting down...", new Object[0]);
        ArrayList futures = Lists.newArrayList();
        for (Map.Entry<SegmentIdentifier, Sink> entry : this.sinks.entrySet()) {
            futures.add(this.abandonSegment(entry.getKey(), entry.getValue(), false));
        }
        try {
            Futures.allAsList((Iterable)futures).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn((Throwable)e, "Interrupted during close()", new Object[0]);
        }
        catch (ExecutionException e) {
            log.warn((Throwable)e, "Unable to abandon existing segments during close()", new Object[0]);
        }
        try {
            this.shutdownExecutors();
            Preconditions.checkState((boolean)this.persistExecutor.awaitTermination(365L, TimeUnit.DAYS), (Object)"persistExecutor not terminated");
            Preconditions.checkState((boolean)this.mergeExecutor.awaitTermination(365L, TimeUnit.DAYS), (Object)"mergeExecutor not terminated");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ISE("Failed to shutdown executors during close()", new Object[0]);
        }
        this.unlockBasePersistDirectory();
    }

    private void lockBasePersistDirectory() {
        if (this.basePersistDirLock == null) {
            try {
                this.basePersistDirLockChannel = FileChannel.open(this.computeLockFile().toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                this.basePersistDirLock = this.basePersistDirLockChannel.tryLock();
                if (this.basePersistDirLock == null) {
                    throw new ISE("Cannot acquire lock on basePersistDir: %s", new Object[]{this.computeLockFile()});
                }
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private void unlockBasePersistDirectory() {
        try {
            if (this.basePersistDirLock != null) {
                this.basePersistDirLock.release();
                this.basePersistDirLockChannel.close();
                this.basePersistDirLock = null;
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void initializeExecutors() {
        int maxPendingPersists = this.tuningConfig.getMaxPendingPersists();
        if (this.persistExecutor == null) {
            this.persistExecutor = MoreExecutors.listeningDecorator((ExecutorService)Execs.newBlockingSingleThreaded((String)"appenderator_persist_%d", (int)maxPendingPersists));
        }
        if (this.mergeExecutor == null) {
            this.mergeExecutor = MoreExecutors.listeningDecorator((ExecutorService)Execs.newBlockingSingleThreaded((String)"appenderator_merge_%d", (int)1));
        }
    }

    private void shutdownExecutors() {
        this.persistExecutor.shutdownNow();
        this.mergeExecutor.shutdownNow();
    }

    private void resetNextFlush() {
        this.nextFlush = new DateTime().plus((ReadablePeriod)this.tuningConfig.getIntermediatePersistPeriod()).getMillis();
    }

    private Object bootstrapSinksFromDisk() {
        Committed committed;
        Preconditions.checkState((boolean)this.sinks.isEmpty(), (Object)"Already bootstrapped?!");
        File baseDir = this.tuningConfig.getBasePersistDirectory();
        if (!baseDir.exists()) {
            return null;
        }
        File[] files = baseDir.listFiles();
        if (files == null) {
            return null;
        }
        File commitFile = this.computeCommitFile();
        try {
            committed = commitFile.exists() ? (Committed)this.objectMapper.readValue(commitFile, Committed.class) : Committed.nil();
        }
        catch (Exception e) {
            throw new ISE((Throwable)e, "Failed to read commitFile: %s", new Object[]{commitFile});
        }
        log.info("Loading sinks from[%s]: %s", new Object[]{baseDir, committed.getHydrants().keySet()});
        for (File sinkDir : files) {
            File identifierFile = new File(sinkDir, IDENTIFIER_FILE_NAME);
            if (!identifierFile.isFile()) continue;
            try {
                SegmentIdentifier identifier = (SegmentIdentifier)this.objectMapper.readValue(new File(sinkDir, IDENTIFIER_FILE_NAME), SegmentIdentifier.class);
                int committedHydrants = committed.getCommittedHydrants(identifier.getIdentifierAsString());
                if (committedHydrants <= 0) {
                    log.info("Removing uncommitted sink at [%s]", new Object[]{sinkDir});
                    FileUtils.deleteDirectory((File)sinkDir);
                    continue;
                }
                File[] sinkFiles = sinkDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String fileName) {
                        return Ints.tryParse((String)fileName) != null;
                    }
                });
                Arrays.sort(sinkFiles, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        return Ints.compare((int)Integer.parseInt(o1.getName()), (int)Integer.parseInt(o2.getName()));
                    }
                });
                ArrayList hydrants = Lists.newArrayList();
                for (File hydrantDir : sinkFiles) {
                    int hydrantNumber = Integer.parseInt(hydrantDir.getName());
                    if (hydrantNumber >= committedHydrants) {
                        log.info("Removing uncommitted segment at [%s]", new Object[]{hydrantDir});
                        FileUtils.deleteDirectory((File)hydrantDir);
                        continue;
                    }
                    log.info("Loading previously persisted segment at [%s]", new Object[]{hydrantDir});
                    if (hydrantNumber != hydrants.size()) {
                        throw new ISE("Missing hydrant [%,d] in sinkDir [%s].", new Object[]{hydrants.size(), sinkDir});
                    }
                    hydrants.add(new FireHydrant((Segment)new QueryableIndexSegment(identifier.getIdentifierAsString(), this.indexIO.loadIndex(hydrantDir)), hydrantNumber));
                }
                if (committedHydrants != hydrants.size()) {
                    throw new ISE("Missing hydrant [%,d] in sinkDir [%s].", new Object[]{hydrants.size(), sinkDir});
                }
                Sink currSink = new Sink(identifier.getInterval(), this.schema, identifier.getShardSpec(), identifier.getVersion(), this.tuningConfig.getMaxRowsInMemory(), this.tuningConfig.isReportParseExceptions(), hydrants);
                this.sinks.put(identifier, currSink);
                this.sinkTimeline.add(currSink.getInterval(), (Object)currSink.getVersion(), identifier.getShardSpec().createChunk((Object)currSink));
                this.segmentAnnouncer.announceSegment(currSink.getSegment());
            }
            catch (IOException e) {
                log.makeAlert((Throwable)e, "Problem loading sink[%s] from disk.", new Object[]{this.schema.getDataSource()}).addData("sinkDir", (Object)sinkDir).emit();
            }
        }
        HashSet loadedSinks = Sets.newHashSet((Iterable)Iterables.transform(this.sinks.keySet(), (Function)new Function<SegmentIdentifier, String>(){

            public String apply(SegmentIdentifier input) {
                return input.getIdentifierAsString();
            }
        }));
        Sets.SetView missingSinks = Sets.difference((Set)committed.getHydrants().keySet(), (Set)loadedSinks);
        if (!missingSinks.isEmpty()) {
            throw new ISE("Missing committed sinks [%s]", new Object[]{Joiner.on((String)", ").join((Iterable)missingSinks)});
        }
        return committed.getMetadata();
    }

    private ListenableFuture<?> abandonSegment(final SegmentIdentifier identifier, final Sink sink, final boolean removeOnDiskData) {
        this.droppingSinks.add(identifier);
        return Futures.transform(this.mergeBarrier(), (Function)new Function<Object, Object>(){

            @Nullable
            public Object apply(@Nullable Object input) {
                if (AppenderatorImpl.this.sinks.get(identifier) != sink) {
                    log.warn("Sink for segment[%s] no longer valid, not abandoning.", new Object[0]);
                    return null;
                }
                if (removeOnDiskData) {
                    log.info("Removing commit metadata for segment[%s].", new Object[]{identifier});
                    try {
                        File commitFile = AppenderatorImpl.this.computeCommitFile();
                        if (commitFile.exists()) {
                            Committed oldCommitted = (Committed)AppenderatorImpl.this.objectMapper.readValue(commitFile, Committed.class);
                            AppenderatorImpl.this.objectMapper.writeValue(commitFile, (Object)oldCommitted.without(identifier.getIdentifierAsString()));
                        }
                    }
                    catch (Exception e) {
                        log.makeAlert((Throwable)e, "Failed to update committed segments[%s]", new Object[]{AppenderatorImpl.this.schema.getDataSource()}).addData("identifier", (Object)identifier.getIdentifierAsString()).emit();
                        throw Throwables.propagate((Throwable)e);
                    }
                }
                try {
                    AppenderatorImpl.this.segmentAnnouncer.unannounceSegment(sink.getSegment());
                }
                catch (Exception e) {
                    log.makeAlert((Throwable)e, "Failed to unannounce segment[%s]", new Object[]{AppenderatorImpl.this.schema.getDataSource()}).addData("identifier", (Object)identifier.getIdentifierAsString()).emit();
                }
                log.info("Removing sink for segment[%s].", new Object[]{identifier});
                AppenderatorImpl.this.sinks.remove(identifier);
                AppenderatorImpl.this.droppingSinks.remove(identifier);
                AppenderatorImpl.this.sinkTimeline.remove(sink.getInterval(), (Object)sink.getVersion(), identifier.getShardSpec().createChunk((Object)sink));
                if (removeOnDiskData) {
                    AppenderatorImpl.this.removeDirectory(AppenderatorImpl.this.computePersistDir(identifier));
                }
                return null;
            }
        }, (Executor)this.persistExecutor);
    }

    private File computeCommitFile() {
        return new File(this.tuningConfig.getBasePersistDirectory(), "commit.json");
    }

    private File computeLockFile() {
        return new File(this.tuningConfig.getBasePersistDirectory(), ".lock");
    }

    private File computePersistDir(SegmentIdentifier identifier) {
        return new File(this.tuningConfig.getBasePersistDirectory(), identifier.getIdentifierAsString());
    }

    private File computeIdentifierFile(SegmentIdentifier identifier) {
        return new File(this.computePersistDir(identifier), IDENTIFIER_FILE_NAME);
    }

    private File computeDescriptorFile(SegmentIdentifier identifier) {
        return new File(this.computePersistDir(identifier), "descriptor.json");
    }

    private File createPersistDirIfNeeded(SegmentIdentifier identifier) throws IOException {
        File persistDir = this.computePersistDir(identifier);
        if (!persistDir.mkdir() && !persistDir.exists()) {
            throw new IOException(String.format("Could not create directory: %s", persistDir));
        }
        this.objectMapper.writeValue(this.computeIdentifierFile(identifier), (Object)identifier);
        return persistDir;
    }

    private int persistHydrant(FireHydrant indexToPersist, SegmentIdentifier identifier) {
        FireHydrant fireHydrant = indexToPersist;
        synchronized (fireHydrant) {
            if (indexToPersist.hasSwapped()) {
                log.info("Segment[%s], Hydrant[%s] already swapped. Ignoring request to persist.", new Object[]{identifier, indexToPersist});
                return 0;
            }
            log.info("Segment[%s], persisting Hydrant[%s]", new Object[]{identifier, indexToPersist});
            try {
                int numRows = indexToPersist.getIndex().size();
                File persistDir = this.createPersistDirIfNeeded(identifier);
                IndexSpec indexSpec = this.tuningConfig.getIndexSpec();
                File persistedFile = this.indexMerger.persist(indexToPersist.getIndex(), identifier.getInterval(), new File(persistDir, String.valueOf(indexToPersist.getCount())), indexSpec);
                indexToPersist.swapSegment((Segment)new QueryableIndexSegment(indexToPersist.getSegment().getIdentifier(), this.indexIO.loadIndex(persistedFile)));
                return numRows;
            }
            catch (IOException e) {
                log.makeAlert("dataSource[%s] -- incremental persist failed", new Object[]{this.schema.getDataSource()}).addData("segment", (Object)identifier.getIdentifierAsString()).addData("count", (Object)indexToPersist.getCount()).emit();
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private void removeDirectory(File target) {
        if (target.exists()) {
            try {
                log.info("Deleting Index File[%s]", new Object[]{target});
                FileUtils.deleteDirectory((File)target);
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Failed to remove directory[%s]", new Object[]{this.schema.getDataSource()}).addData("file", (Object)target).emit();
            }
        }
    }

    private static String makeHydrantCacheIdentifier(FireHydrant input, Segment segment) {
        return segment.getIdentifier() + "_" + input.getCount();
    }
}

