/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.SegmentPublisher;
import io.druid.segment.realtime.appenderator.Appenderator;
import io.druid.segment.realtime.appenderator.AppenderatorFactory;
import io.druid.segment.realtime.appenderator.AppenderatorPlumber;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.PlumberSchool;
import io.druid.segment.realtime.plumber.SegmentHandoffNotifierFactory;
import io.druid.server.coordination.DataSegmentAnnouncer;

public class AppenderatorPlumberSchool
implements PlumberSchool {
    private final AppenderatorFactory appenderatorFactory;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final SegmentHandoffNotifierFactory handoffNotifierFactory;
    private final SegmentPublisher segmentPublisher;

    @JsonCreator
    public AppenderatorPlumberSchool(@JsonProperty(value="appenderator") AppenderatorFactory appenderatorFactory, @JacksonInject DataSegmentAnnouncer segmentAnnouncer, @JacksonInject SegmentHandoffNotifierFactory handoffNotifierFactory, @JacksonInject SegmentPublisher segmentPublisher) {
        this.appenderatorFactory = appenderatorFactory;
        this.segmentAnnouncer = segmentAnnouncer;
        this.handoffNotifierFactory = handoffNotifierFactory;
        this.segmentPublisher = segmentPublisher;
    }

    @Override
    public Plumber findPlumber(DataSchema schema, RealtimeTuningConfig config, FireDepartmentMetrics metrics) {
        Appenderator appenderator = this.appenderatorFactory.build(schema, config, metrics);
        return new AppenderatorPlumber(schema, config, metrics, this.segmentAnnouncer, this.segmentPublisher, this.handoffNotifierFactory.createSegmentHandoffNotifier(schema.getDataSource()), appenderator);
    }

    @JsonProperty(value="appenderator")
    public AppenderatorFactory getAppenderatorFactory() {
        return this.appenderatorFactory;
    }
}

