/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.druid.timeline.DataSegment;
import io.druid.timeline.partition.ShardSpec;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class SegmentIdentifier {
    private final String dataSource;
    private final Interval interval;
    private final String version;
    private final ShardSpec shardSpec;
    private final String asString;

    @JsonCreator
    public SegmentIdentifier(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="version") String version, @JsonProperty(value="shardSpec") ShardSpec shardSpec) {
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
        this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
        this.shardSpec = (ShardSpec)Preconditions.checkNotNull((Object)shardSpec, (Object)"shardSpec");
        this.asString = DataSegment.makeDataSegmentIdentifier((String)dataSource, (DateTime)interval.getStart(), (DateTime)interval.getEnd(), (String)version, (ShardSpec)shardSpec);
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public ShardSpec getShardSpec() {
        return this.shardSpec;
    }

    public String getIdentifierAsString() {
        return this.asString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentIdentifier that = (SegmentIdentifier)o;
        return Objects.equals(this.asString, that.asString);
    }

    public int hashCode() {
        return this.asString.hashCode();
    }

    public String toString() {
        return this.asString;
    }

    public static SegmentIdentifier fromDataSegment(DataSegment segment) {
        return new SegmentIdentifier(segment.getDataSource(), segment.getInterval(), segment.getVersion(), segment.getShardSpec());
    }
}

