/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.firehose;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.CountingInputStream;
import com.metamx.emitter.EmittingLogger;
import io.druid.concurrent.Execs;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.MapInputRowParser;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Smile;
import io.druid.segment.realtime.firehose.ChatHandler;
import io.druid.segment.realtime.firehose.ChatHandlerProvider;
import io.druid.server.metrics.EventReceiverFirehoseMetric;
import io.druid.server.metrics.EventReceiverFirehoseRegister;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;

public class EventReceiverFirehoseFactory
implements FirehoseFactory<MapInputRowParser> {
    private static final EmittingLogger log = new EmittingLogger(EventReceiverFirehoseFactory.class);
    private static final int DEFAULT_BUFFER_SIZE = 100000;
    private final String serviceName;
    private final int bufferSize;
    private final Optional<ChatHandlerProvider> chatHandlerProvider;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private final EventReceiverFirehoseRegister eventReceiverFirehoseRegister;

    @JsonCreator
    public EventReceiverFirehoseFactory(@JsonProperty(value="serviceName") String serviceName, @JsonProperty(value="bufferSize") Integer bufferSize, @JacksonInject ChatHandlerProvider chatHandlerProvider, @JacksonInject @Json ObjectMapper jsonMapper, @JacksonInject @Smile ObjectMapper smileMapper, @JacksonInject EventReceiverFirehoseRegister eventReceiverFirehoseRegister) {
        Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
        this.serviceName = serviceName;
        this.bufferSize = bufferSize == null || bufferSize <= 0 ? 100000 : bufferSize;
        this.chatHandlerProvider = Optional.fromNullable((Object)chatHandlerProvider);
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.eventReceiverFirehoseRegister = eventReceiverFirehoseRegister;
    }

    public Firehose connect(MapInputRowParser firehoseParser) throws IOException {
        log.info("Connecting firehose: %s", new Object[]{this.serviceName});
        EventReceiverFirehose firehose = new EventReceiverFirehose(firehoseParser);
        if (this.chatHandlerProvider.isPresent()) {
            log.info("Found chathandler of class[%s]", new Object[]{((ChatHandlerProvider)this.chatHandlerProvider.get()).getClass().getName()});
            ((ChatHandlerProvider)this.chatHandlerProvider.get()).register(this.serviceName, firehose);
            if (this.serviceName.contains(":")) {
                ((ChatHandlerProvider)this.chatHandlerProvider.get()).register(this.serviceName.replaceAll(".*:", ""), firehose);
            }
        } else {
            log.warn("No chathandler detected", new Object[0]);
        }
        this.eventReceiverFirehoseRegister.register(this.serviceName, firehose);
        return firehose;
    }

    @JsonProperty
    public String getServiceName() {
        return this.serviceName;
    }

    @JsonProperty
    public int getBufferSize() {
        return this.bufferSize;
    }

    public class EventReceiverFirehose
    implements ChatHandler,
    Firehose,
    EventReceiverFirehoseMetric {
        private final ScheduledExecutorService exec;
        private final BlockingQueue<InputRow> buffer;
        private final MapInputRowParser parser;
        private final Object readLock = new Object();
        private volatile InputRow nextRow = null;
        private volatile boolean closed = false;
        private final AtomicLong bytesReceived = new AtomicLong(0L);

        public EventReceiverFirehose(MapInputRowParser parser) {
            this.buffer = new ArrayBlockingQueue<InputRow>(EventReceiverFirehoseFactory.this.bufferSize);
            this.parser = parser;
            this.exec = Execs.scheduledSingleThreaded((String)"event-receiver-firehose-%d");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @POST
        @Path(value="/push-events")
        @Consumes(value={"application/json", "application/x-jackson-smile"})
        @Produces(value={"application/json", "application/x-jackson-smile"})
        public Response addAll(InputStream in, @Context HttpServletRequest req) {
            String reqContentType = req.getContentType();
            boolean isSmile = "application/x-jackson-smile".equals(reqContentType);
            String contentType = isSmile ? "application/x-jackson-smile" : "application/json";
            ObjectMapper objectMapper = isSmile ? EventReceiverFirehoseFactory.this.smileMapper : EventReceiverFirehoseFactory.this.jsonMapper;
            CountingInputStream countingInputStream = new CountingInputStream(in);
            Collection events = null;
            try {
                events = (Collection)objectMapper.readValue((InputStream)countingInputStream, (TypeReference)new TypeReference<Collection<Map<String, Object>>>(){});
            }
            catch (IOException e) {
                Response response = Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)e.getMessage())).build();
                return response;
            }
            finally {
                this.bytesReceived.addAndGet(countingInputStream.getCount());
            }
            log.debug("Adding %,d events to firehose: %s", new Object[]{events.size(), EventReceiverFirehoseFactory.this.serviceName});
            ArrayList rows = Lists.newArrayList();
            for (Map event : events) {
                rows.add(this.parser.parse(event));
            }
            try {
                this.addRows(rows);
                return Response.ok((Object)objectMapper.writeValueAsString((Object)ImmutableMap.of((Object)"eventCount", (Object)events.size())), (String)contentType).build();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
            catch (JsonProcessingException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasMore() {
            Object object = this.readLock;
            synchronized (object) {
                try {
                    while (this.nextRow == null) {
                        this.nextRow = this.buffer.poll(500L, TimeUnit.MILLISECONDS);
                        if (!this.closed) continue;
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Throwables.propagate((Throwable)e);
                }
                return this.nextRow != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputRow nextRow() {
            Object object = this.readLock;
            synchronized (object) {
                InputRow row = this.nextRow;
                if (row == null) {
                    throw new NoSuchElementException();
                }
                this.nextRow = null;
                return row;
            }
        }

        public Runnable commit() {
            return new Runnable(){

                @Override
                public void run() {
                }
            };
        }

        @Override
        public int getCurrentBufferSize() {
            return this.buffer.size();
        }

        @Override
        public int getCapacity() {
            return EventReceiverFirehoseFactory.this.bufferSize;
        }

        @Override
        public long getBytesReceived() {
            return this.bytesReceived.get();
        }

        public void close() throws IOException {
            if (!this.closed) {
                log.info("Firehose closing.", new Object[0]);
                this.closed = true;
                EventReceiverFirehoseFactory.this.eventReceiverFirehoseRegister.unregister(EventReceiverFirehoseFactory.this.serviceName);
                if (EventReceiverFirehoseFactory.this.chatHandlerProvider.isPresent()) {
                    ((ChatHandlerProvider)EventReceiverFirehoseFactory.this.chatHandlerProvider.get()).unregister(EventReceiverFirehoseFactory.this.serviceName);
                }
                this.exec.shutdown();
            }
        }

        public void addRows(Iterable<InputRow> rows) throws InterruptedException {
            for (InputRow row : rows) {
                boolean added = false;
                while (!this.closed && !added) {
                    added = this.buffer.offer(row, 500L, TimeUnit.MILLISECONDS);
                }
                if (added) continue;
                throw new IllegalStateException("Cannot add events to closed firehose!");
            }
        }

        @POST
        @Path(value="/shutdown")
        @Consumes(value={"application/json", "application/x-jackson-smile"})
        @Produces(value={"application/json", "application/x-jackson-smile"})
        public Response shutdown(@QueryParam(value="shutoffTime") String shutoffTime) {
            try {
                DateTime shutoffAt = shutoffTime == null ? DateTime.now() : new DateTime((Object)shutoffTime);
                log.info("Setting Firehose shutoffTime to %s", new Object[]{shutoffTime});
                this.exec.schedule(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            EventReceiverFirehose.this.close();
                        }
                        catch (IOException e) {
                            log.warn((Throwable)e, "Failed to close delegate firehose, ignoring.", new Object[0]);
                        }
                    }
                }, shutoffAt.getMillis() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                return Response.ok().build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)e.getMessage())).build();
            }
        }

        @VisibleForTesting
        public boolean isClosed() {
            return this.closed;
        }
    }
}

