/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.plumber;

import io.druid.segment.realtime.plumber.RejectionPolicy;
import io.druid.segment.realtime.plumber.RejectionPolicyFactory;
import org.joda.time.DateTime;
import org.joda.time.Period;

public class MessageTimeRejectionPolicyFactory
implements RejectionPolicyFactory {
    @Override
    public RejectionPolicy create(final Period windowPeriod) {
        final long windowMillis = windowPeriod.toStandardDuration().getMillis();
        return new RejectionPolicy(){
            private volatile long maxTimestamp = -4611686018427387904L;

            @Override
            public DateTime getCurrMaxTime() {
                return new DateTime(this.maxTimestamp);
            }

            @Override
            public boolean accept(long timestamp) {
                this.maxTimestamp = Math.max(this.maxTimestamp, timestamp);
                return timestamp >= this.maxTimestamp - windowMillis;
            }

            public String toString() {
                return String.format("messageTime-%s", windowPeriod);
            }
        };
    }
}

