/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.plumber;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import io.druid.data.input.InputRow;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.QueryableIndex;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.segment.incremental.IndexSizeExceededException;
import io.druid.segment.incremental.OnheapIncrementalIndex;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.realtime.FireHydrant;
import io.druid.timeline.DataSegment;
import io.druid.timeline.partition.ShardSpec;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.joda.time.Interval;

public class Sink
implements Iterable<FireHydrant> {
    private static final int ADD_FAILED = -1;
    private final Object hydrantLock = new Object();
    private final Interval interval;
    private final DataSchema schema;
    private final ShardSpec shardSpec;
    private final String version;
    private final int maxRowsInMemory;
    private final boolean reportParseExceptions;
    private final CopyOnWriteArrayList<FireHydrant> hydrants = new CopyOnWriteArrayList();
    private final LinkedHashSet<String> dimOrder = Sets.newLinkedHashSet();
    private final AtomicInteger numRowsExcludingCurrIndex = new AtomicInteger();
    private volatile FireHydrant currHydrant;
    private volatile boolean writable = true;

    public Sink(Interval interval, DataSchema schema, ShardSpec shardSpec, String version, int maxRowsInMemory, boolean reportParseExceptions) {
        this.schema = schema;
        this.shardSpec = shardSpec;
        this.interval = interval;
        this.version = version;
        this.maxRowsInMemory = maxRowsInMemory;
        this.reportParseExceptions = reportParseExceptions;
        this.makeNewCurrIndex(interval.getStartMillis(), schema);
    }

    public Sink(Interval interval, DataSchema schema, ShardSpec shardSpec, String version, int maxRowsInMemory, boolean reportParseExceptions, List<FireHydrant> hydrants) {
        this.schema = schema;
        this.shardSpec = shardSpec;
        this.interval = interval;
        this.version = version;
        this.maxRowsInMemory = maxRowsInMemory;
        this.reportParseExceptions = reportParseExceptions;
        int maxCount = -1;
        for (int i = 0; i < hydrants.size(); ++i) {
            FireHydrant hydrant = hydrants.get(i);
            if (hydrant.getCount() <= maxCount) {
                throw new ISE("hydrant[%s] not the right count[%s]", new Object[]{hydrant, i});
            }
            maxCount = hydrant.getCount();
            this.numRowsExcludingCurrIndex.addAndGet(hydrant.getSegment().asQueryableIndex().getNumRows());
        }
        this.hydrants.addAll(hydrants);
        this.makeNewCurrIndex(interval.getStartMillis(), schema);
    }

    public String getVersion() {
        return this.version;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public FireHydrant getCurrHydrant() {
        return this.currHydrant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(InputRow row) throws IndexSizeExceededException {
        if (this.currHydrant == null) {
            throw new IAE("No currHydrant but given row[%s]", new Object[]{row});
        }
        Object object = this.hydrantLock;
        synchronized (object) {
            if (!this.writable) {
                return -1;
            }
            IncrementalIndex index = this.currHydrant.getIndex();
            if (index == null) {
                return -1;
            }
            return index.add(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAppendRow() {
        Object object = this.hydrantLock;
        synchronized (object) {
            return this.writable && this.currHydrant != null && this.currHydrant.getIndex().canAppendRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.hydrantLock;
        synchronized (object) {
            return this.hydrants.size() == 1 && this.currHydrant.getIndex().isEmpty();
        }
    }

    public boolean isWritable() {
        return this.writable;
    }

    public FireHydrant swap() {
        return this.makeNewCurrIndex(this.interval.getStartMillis(), this.schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean swappable() {
        Object object = this.hydrantLock;
        synchronized (object) {
            return this.writable && this.currHydrant.getIndex() != null && this.currHydrant.getIndex().size() != 0;
        }
    }

    public boolean finished() {
        return !this.writable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishWriting() {
        Object object = this.hydrantLock;
        synchronized (object) {
            this.writable = false;
        }
    }

    public DataSegment getSegment() {
        return new DataSegment(this.schema.getDataSource(), this.interval, this.version, (Map)ImmutableMap.of(), (List)Lists.newArrayList(), Lists.transform(Arrays.asList(this.schema.getAggregators()), (Function)new Function<AggregatorFactory, String>(){

            public String apply(@Nullable AggregatorFactory input) {
                return input.getName();
            }
        }), this.shardSpec, null, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRows() {
        Object object = this.hydrantLock;
        synchronized (object) {
            return this.numRowsExcludingCurrIndex.get() + this.currHydrant.getIndex().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FireHydrant makeNewCurrIndex(long minTimestamp, DataSchema schema) {
        FireHydrant old;
        IncrementalIndexSchema indexSchema = new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withQueryGranularity(schema.getGranularitySpec().getQueryGranularity()).withDimensionsSpec(schema.getParser()).withMetrics(schema.getAggregators()).build();
        OnheapIncrementalIndex newIndex = new OnheapIncrementalIndex(indexSchema, this.reportParseExceptions, this.maxRowsInMemory);
        Object object = this.hydrantLock;
        synchronized (object) {
            if (this.writable) {
                old = this.currHydrant;
                int newCount = 0;
                int numHydrants = this.hydrants.size();
                if (numHydrants > 0) {
                    FireHydrant lastHydrant = this.hydrants.get(numHydrants - 1);
                    newCount = lastHydrant.getCount() + 1;
                    if (!indexSchema.getDimensionsSpec().hasCustomDimensions()) {
                        if (lastHydrant.hasSwapped()) {
                            QueryableIndex oldIndex = lastHydrant.getSegment().asQueryableIndex();
                            for (String dim : oldIndex.getAvailableDimensions()) {
                                this.dimOrder.add(dim);
                            }
                        } else {
                            IncrementalIndex oldIndex = lastHydrant.getIndex();
                            this.dimOrder.addAll(oldIndex.getDimensionOrder());
                        }
                        newIndex.loadDimensionIterable(this.dimOrder);
                    }
                }
                this.currHydrant = new FireHydrant((IncrementalIndex)newIndex, newCount, this.getSegment().getIdentifier());
                if (old != null) {
                    this.numRowsExcludingCurrIndex.addAndGet(old.getIndex().size());
                }
            } else {
                newIndex.close();
                throw new ISE("finishWriting() called during swap", new Object[0]);
            }
            this.hydrants.add(this.currHydrant);
        }
        return old;
    }

    @Override
    public Iterator<FireHydrant> iterator() {
        return Iterators.filter(this.hydrants.iterator(), (Predicate)new Predicate<FireHydrant>(){

            public boolean apply(FireHydrant input) {
                IncrementalIndex index = input.getIndex();
                return index == null || index.size() != 0;
            }
        });
    }

    public String toString() {
        return "Sink{interval=" + this.interval + ", schema=" + this.schema + '}';
    }
}

