/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import com.google.common.collect.Maps;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Ordering;
import io.druid.client.ImmutableDruidServer;
import io.druid.server.coordinator.ServerHolder;
import java.util.Comparator;
import java.util.Map;

public class DruidCluster {
    private final Map<String, MinMaxPriorityQueue<ServerHolder>> cluster;

    public DruidCluster() {
        this.cluster = Maps.newHashMap();
    }

    public DruidCluster(Map<String, MinMaxPriorityQueue<ServerHolder>> cluster) {
        this.cluster = cluster;
    }

    public void add(ServerHolder serverHolder) {
        ImmutableDruidServer server = serverHolder.getServer();
        MinMaxPriorityQueue tierServers = this.cluster.get(server.getTier());
        if (tierServers == null) {
            tierServers = MinMaxPriorityQueue.orderedBy((Comparator)Ordering.natural().reverse()).create();
            this.cluster.put(server.getTier(), (MinMaxPriorityQueue<ServerHolder>)tierServers);
        }
        tierServers.add((Object)serverHolder);
    }

    public Map<String, MinMaxPriorityQueue<ServerHolder>> getCluster() {
        return this.cluster;
    }

    public Iterable<String> getTierNames() {
        return this.cluster.keySet();
    }

    public MinMaxPriorityQueue<ServerHolder> getServersByTier(String tier) {
        return this.cluster.get(tier);
    }

    public Iterable<MinMaxPriorityQueue<ServerHolder>> getSortedServersByTier() {
        return this.cluster.values();
    }

    public boolean isEmpty() {
        return this.cluster.isEmpty();
    }

    public boolean hasTier(String tier) {
        MinMaxPriorityQueue<ServerHolder> servers = this.cluster.get(tier);
        return servers == null || servers.isEmpty();
    }

    public MinMaxPriorityQueue<ServerHolder> get(String tier) {
        return this.cluster.get(tier);
    }
}

