/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MinMaxPriorityQueue;
import com.metamx.common.guava.Comparators;
import com.metamx.emitter.EmittingLogger;
import io.druid.client.ImmutableDruidServer;
import io.druid.server.coordinator.BalancerSegmentHolder;
import io.druid.server.coordinator.BalancerStrategy;
import io.druid.server.coordinator.CoordinatorStats;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import io.druid.server.coordinator.LoadPeonCallback;
import io.druid.server.coordinator.LoadQueuePeon;
import io.druid.server.coordinator.ServerHolder;
import io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import io.druid.timeline.DataSegment;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;

public class DruidCoordinatorBalancer
implements DruidCoordinatorHelper {
    public static final Comparator<ServerHolder> percentUsedComparator = Comparators.inverse((Comparator)new Comparator<ServerHolder>(){

        @Override
        public int compare(ServerHolder lhs, ServerHolder rhs) {
            return lhs.getPercentUsed().compareTo(rhs.getPercentUsed());
        }
    });
    protected static final EmittingLogger log = new EmittingLogger(DruidCoordinatorBalancer.class);
    protected final DruidCoordinator coordinator;
    protected final Map<String, ConcurrentHashMap<String, BalancerSegmentHolder>> currentlyMovingSegments = Maps.newHashMap();

    public DruidCoordinatorBalancer(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    protected void reduceLifetimes(String tier) {
        for (BalancerSegmentHolder holder : this.currentlyMovingSegments.get(tier).values()) {
            holder.reduceLifetime();
            if (holder.getLifetime() > 0) continue;
            log.makeAlert("[%s]: Balancer move segments queue has a segment stuck", new Object[]{tier}).addData("segment", (Object)holder.getSegment().getIdentifier()).addData("server", (Object)holder.getFromServer().getMetadata()).emit();
        }
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        CoordinatorStats stats = new CoordinatorStats();
        DateTime referenceTimestamp = params.getBalancerReferenceTimestamp();
        BalancerStrategy strategy = params.getBalancerStrategyFactory().createBalancerStrategy(referenceTimestamp);
        int maxSegmentsToMove = params.getCoordinatorDynamicConfig().getMaxSegmentsToMove();
        for (Map.Entry<String, MinMaxPriorityQueue<ServerHolder>> entry : params.getDruidCluster().getCluster().entrySet()) {
            String tier = entry.getKey();
            if (this.currentlyMovingSegments.get(tier) == null) {
                this.currentlyMovingSegments.put(tier, new ConcurrentHashMap());
            }
            if (!this.currentlyMovingSegments.get(tier).isEmpty()) {
                this.reduceLifetimes(tier);
                log.info("[%s]: Still waiting on %,d segments to be moved", new Object[]{tier, this.currentlyMovingSegments.size()});
                continue;
            }
            ArrayList serverHolderList = Lists.newArrayList((Iterable)((Iterable)entry.getValue()));
            if (serverHolderList.size() <= 1) {
                log.info("[%s]: One or fewer servers found.  Cannot balance.", new Object[]{tier});
                continue;
            }
            int numSegments = 0;
            for (ServerHolder server : serverHolderList) {
                numSegments += server.getServer().getSegments().size();
            }
            if (numSegments == 0) {
                log.info("No segments found.  Cannot balance.", new Object[0]);
                continue;
            }
            for (int iter = 0; iter < maxSegmentsToMove; ++iter) {
                ServerHolder holder;
                BalancerSegmentHolder segmentToMove = strategy.pickSegmentToMove(serverHolderList);
                if (segmentToMove == null || !params.getAvailableSegments().contains(segmentToMove.getSegment()) || (holder = strategy.findNewSegmentHomeBalancer(segmentToMove.getSegment(), serverHolderList)) == null) continue;
                this.moveSegment(segmentToMove, holder.getServer(), params);
            }
            stats.addToTieredStat("movedCount", tier, this.currentlyMovingSegments.get(tier).size());
            if (params.getCoordinatorDynamicConfig().emitBalancingStats()) {
                strategy.emitStats(tier, stats, serverHolderList);
            }
            log.info("[%s]: Segments Moved: [%d]", new Object[]{tier, this.currentlyMovingSegments.get(tier).size()});
        }
        return params.buildFromExisting().withCoordinatorStats(stats).build();
    }

    protected void moveSegment(BalancerSegmentHolder segment, final ImmutableDruidServer toServer, DruidCoordinatorRuntimeParams params) {
        LoadQueuePeon toPeon = params.getLoadManagementPeons().get(toServer.getName());
        ImmutableDruidServer fromServer = segment.getFromServer();
        DataSegment segmentToMove = segment.getSegment();
        final String segmentName = segmentToMove.getIdentifier();
        if (!toPeon.getSegmentsToLoad().contains(segmentToMove) && toServer.getSegment(segmentName) == null && new ServerHolder(toServer, toPeon).getAvailableSize() > segmentToMove.getSize()) {
            log.info("Moving [%s] from [%s] to [%s]", new Object[]{segmentName, fromServer.getName(), toServer.getName()});
            LoadPeonCallback callback = null;
            try {
                this.currentlyMovingSegments.get(toServer.getTier()).put(segmentName, segment);
                callback = new LoadPeonCallback(){

                    @Override
                    public void execute() {
                        Map movingSegments = DruidCoordinatorBalancer.this.currentlyMovingSegments.get(toServer.getTier());
                        if (movingSegments != null) {
                            movingSegments.remove(segmentName);
                        }
                    }
                };
                this.coordinator.moveSegment(fromServer, toServer, segmentToMove.getIdentifier(), callback);
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, String.format("[%s] : Moving exception", segmentName), new Object[0]).emit();
                if (callback != null) {
                    callback.execute();
                }
            }
        } else {
            this.currentlyMovingSegments.get(toServer.getTier()).remove(segmentName);
        }
    }
}

