/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.metrics;

import com.google.inject.Inject;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import com.metamx.metrics.AbstractMonitor;
import io.druid.client.DruidServerConfig;
import io.druid.server.coordination.ServerManager;
import java.util.Map;

public class HistoricalMetricsMonitor
extends AbstractMonitor {
    private final DruidServerConfig serverConfig;
    private final ServerManager serverManager;

    @Inject
    public HistoricalMetricsMonitor(DruidServerConfig serverConfig, ServerManager serverManager) {
        this.serverConfig = serverConfig;
        this.serverManager = serverManager;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder;
        String dataSource;
        emitter.emit(new ServiceMetricEvent.Builder().build("segment/max", (Number)this.serverConfig.getMaxSize()));
        for (Map.Entry<String, Long> entry : this.serverManager.getDataSourceSizes().entrySet()) {
            dataSource = entry.getKey();
            long used = entry.getValue();
            builder = new ServiceMetricEvent.Builder().setDimension("dataSource", dataSource).setDimension("tier", this.serverConfig.getTier()).setDimension("priority", String.valueOf(this.serverConfig.getPriority()));
            emitter.emit(builder.build("segment/used", (Number)used));
            double usedPercent = this.serverConfig.getMaxSize() == 0L ? 0.0 : (double)used / (double)this.serverConfig.getMaxSize();
            emitter.emit(builder.build("segment/usedPercent", (Number)usedPercent));
        }
        for (Map.Entry<String, Long> entry : this.serverManager.getDataSourceCounts().entrySet()) {
            dataSource = entry.getKey();
            long count = entry.getValue();
            builder = new ServiceMetricEvent.Builder().setDimension("dataSource", dataSource).setDimension("tier", this.serverConfig.getTier()).setDimension("priority", String.valueOf(this.serverConfig.getPriority()));
            emitter.emit(builder.build("segment/count", (Number)count));
        }
        return true;
    }
}

