/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.router;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.druid.query.Query;
import io.druid.server.router.TieredBrokerConfig;
import io.druid.server.router.TieredBrokerSelectorStrategy;
import javax.script.Compilable;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JavaScriptTieredBrokerSelectorStrategy
implements TieredBrokerSelectorStrategy {
    private final SelectorFunction fnSelector;
    private final String function;

    @JsonCreator
    public JavaScriptTieredBrokerSelectorStrategy(@JsonProperty(value="function") String fn) {
        Preconditions.checkNotNull((Object)fn, (Object)"function must not be null");
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");
        try {
            ((Compilable)((Object)engine)).compile("var apply = " + fn).eval();
        }
        catch (ScriptException e) {
            Throwables.propagate((Throwable)e);
        }
        this.function = fn;
        this.fnSelector = ((Invocable)((Object)engine)).getInterface(SelectorFunction.class);
    }

    @Override
    public Optional<String> getBrokerServiceName(TieredBrokerConfig config, Query query) {
        return Optional.fromNullable((Object)this.fnSelector.apply(config, query));
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaScriptTieredBrokerSelectorStrategy that = (JavaScriptTieredBrokerSelectorStrategy)o;
        return this.function.equals(that.function);
    }

    public int hashCode() {
        return this.function.hashCode();
    }

    public String toString() {
        return "JavascriptTieredBrokerSelectorStrategy{function='" + this.function + '\'' + '}';
    }

    public static interface SelectorFunction {
        public String apply(TieredBrokerConfig var1, Query var2);
    }
}

