/*
 * Decompiled with CFR 0.152.
 */
package io.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.druid.data.input.InputRow;
import io.druid.data.input.Rows;
import io.druid.timeline.partition.NumberedShardSpec;
import io.druid.timeline.partition.ShardSpec;
import io.druid.timeline.partition.ShardSpecLookup;
import java.util.List;
import javax.annotation.Nullable;

public class HashBasedNumberedShardSpec
extends NumberedShardSpec {
    private static final HashFunction hashFunction = Hashing.murmur3_32();
    private static final List<String> DEFAULT_PARTITION_DIMENSIONS = ImmutableList.of();
    private final ObjectMapper jsonMapper;
    @JsonIgnore
    private final List<String> partitionDimensions;

    @JsonCreator
    public HashBasedNumberedShardSpec(@JsonProperty(value="partitionNum") int partitionNum, @JsonProperty(value="partitions") int partitions, @JsonProperty(value="partitionDimensions") @Nullable List<String> partitionDimensions, @JacksonInject ObjectMapper jsonMapper) {
        super(partitionNum, partitions);
        this.jsonMapper = jsonMapper;
        this.partitionDimensions = partitionDimensions == null ? DEFAULT_PARTITION_DIMENSIONS : partitionDimensions;
    }

    @JsonProperty(value="partitionDimensions")
    public List<String> getPartitionDimensions() {
        return this.partitionDimensions;
    }

    @Override
    public boolean isInChunk(long timestamp, InputRow inputRow) {
        return ((long)this.hash(timestamp, inputRow) - (long)this.getPartitionNum()) % (long)this.getPartitions() == 0L;
    }

    protected int hash(long timestamp, InputRow inputRow) {
        List<Object> groupKey = this.getGroupKey(timestamp, inputRow);
        try {
            return hashFunction.hashBytes(this.jsonMapper.writeValueAsBytes(groupKey)).asInt();
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    List<Object> getGroupKey(long timestamp, final InputRow inputRow) {
        if (this.partitionDimensions.isEmpty()) {
            return Rows.toGroupKey((long)timestamp, (InputRow)inputRow);
        }
        return Lists.transform(this.partitionDimensions, (Function)new Function<String, Object>(){

            public Object apply(String dim) {
                return inputRow.getDimension(dim);
            }
        });
    }

    @Override
    public String toString() {
        return "HashBasedNumberedShardSpec{partitionNum=" + this.getPartitionNum() + ", partitions=" + this.getPartitions() + ", partitionDimensions=" + this.getPartitionDimensions() + '}';
    }

    @Override
    public ShardSpecLookup getLookup(final List<ShardSpec> shardSpecs) {
        return new ShardSpecLookup(){

            public ShardSpec getShardSpec(long timestamp, InputRow row) {
                int index = Math.abs(HashBasedNumberedShardSpec.this.hash(timestamp, row) % HashBasedNumberedShardSpec.this.getPartitions());
                return (ShardSpec)shardSpecs.get(index);
            }
        };
    }
}

