/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.listeners;

import com.ircclouds.irc.api.Callback;
import com.ircclouds.irc.api.IIRCSession;
import com.ircclouds.irc.api.IServerParameters;
import com.ircclouds.irc.api.domain.IRCChannel;
import com.ircclouds.irc.api.domain.IRCUserStatuses;
import com.ircclouds.irc.api.domain.WritableIRCChannel;
import com.ircclouds.irc.api.domain.messages.ChanJoinMessage;
import com.ircclouds.irc.api.domain.messages.ChanPartMessage;
import com.ircclouds.irc.api.domain.messages.ChannelKick;
import com.ircclouds.irc.api.domain.messages.ErrorMessage;
import com.ircclouds.irc.api.domain.messages.NickMessage;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import com.ircclouds.irc.api.domain.messages.interfaces.IUserMessage;
import com.ircclouds.irc.api.listeners.AbstractChannelJoinListener;
import com.ircclouds.irc.api.listeners.AbstractChannelPartListener;
import com.ircclouds.irc.api.listeners.AbstractNickChangeListener;
import com.ircclouds.irc.api.listeners.AsyncMessageListener;
import com.ircclouds.irc.api.listeners.ConnectCmdListener;
import com.ircclouds.irc.api.listeners.KickUserListener;
import com.ircclouds.irc.api.listeners.VariousMessageListenerAdapter;
import com.ircclouds.irc.api.state.IIRCState;
import com.ircclouds.irc.api.state.IRCStateImpl;
import com.ircclouds.irc.api.state.IStateAccessor;

public abstract class AbstractExecuteCommandListener
extends VariousMessageListenerAdapter
implements IStateAccessor {
    private AbstractChannelJoinListener chanJoinListener = new AbstractChannelJoinListener(){

        @Override
        public void saveChannel(WritableIRCChannel aChannel) {
            AbstractExecuteCommandListener.this.saveChan(aChannel);
        }

        @Override
        protected IRCUserStatuses getIRCUserStatuses() {
            return AbstractExecuteCommandListener.this.getIRCState().getServerOptions().getUserChanStatuses();
        }
    };
    private AbstractChannelPartListener chanPartListener = new AbstractChannelPartListener(){

        @Override
        protected void deleteChannel(String aChannelName) {
            AbstractExecuteCommandListener.this.deleteChan(aChannelName);
        }
    };
    private ConnectCmdListener connectListener;
    private AbstractNickChangeListener nickChangeListener;
    private KickUserListener kickUserListener;
    private AsyncMessageListener messsageListener;

    public AbstractExecuteCommandListener(IIRCSession aSession) {
        this.connectListener = new ConnectCmdListener(aSession);
        this.nickChangeListener = new AbstractNickChangeListener(){

            @Override
            protected void changeNick(String aNewNick) {
                AbstractExecuteCommandListener.this.updateNick(aNewNick);
            }
        };
        this.kickUserListener = new KickUserListener(){

            @Override
            protected void delChanUser(String aChan, String aUser) {
                AbstractExecuteCommandListener.this.deleteNickFromChan(aChan, aUser);
            }
        };
        this.messsageListener = new AsyncMessageListener();
    }

    @Override
    public void onChannelJoin(ChanJoinMessage aMsg) {
        if (this.isForMe(aMsg)) {
            this.chanJoinListener.onChanJoinMessage(aMsg);
        }
    }

    @Override
    public void onChannelPart(ChanPartMessage aMsg) {
        if (this.isForMe(aMsg)) {
            this.chanPartListener.onChannelPart(aMsg);
        }
    }

    @Override
    public void onChannelKick(ChannelKick aChanKick) {
        if (this.isForMe(aChanKick)) {
            this.kickUserListener.onChannelKick(aChanKick);
        }
    }

    @Override
    public void onServerNumericMessage(ServerNumericMessage aMsg) {
        this.chanJoinListener.onServerMessage(aMsg);
        this.chanPartListener.onServerMessage(aMsg);
        if (!this.getIRCState().isConnected()) {
            this.connectListener.onServerMessage(aMsg);
        }
        this.nickChangeListener.onServerMessage(aMsg);
        this.messsageListener.onServerMsg(aMsg);
        this.kickUserListener.onServerMessage(aMsg);
    }

    @Override
    public void onError(ErrorMessage aMsg) {
        if (!this.getIRCState().isConnected()) {
            this.connectListener.onError(aMsg);
        }
        if (this.getIRCState() instanceof IRCStateImpl) {
            ((IRCStateImpl)this.getIRCState()).setConnected(false);
        }
    }

    @Override
    public void onNickChange(NickMessage aMsg) {
        if (this.isForMe(aMsg)) {
            this.nickChangeListener.onNickChange(aMsg);
            this.updateNick(aMsg.getNewNick());
        }
    }

    public void submitConnectCallback(Callback<IIRCState> aCallback, IServerParameters aServerParameters) {
        this.connectListener.setCallback(aCallback, aServerParameters);
    }

    public void submitJoinChannelCallback(String aChanName, Callback<IRCChannel> aCallback) {
        this.chanJoinListener.submit(aChanName, aCallback);
    }

    public void submitPartChannelCallback(String aChanName, Callback<String> aCallback) {
        this.chanPartListener.submit(aChanName, aCallback);
    }

    public void submitChangeNickCallback(String aNewNickname, Callback<String> aCallback) {
        this.nickChangeListener.submit(aNewNickname, aCallback);
    }

    public void submitSendMessageCallback(int aAsyncId, Callback<String> aCallback) {
        this.messsageListener.submit(aAsyncId, aCallback);
    }

    public void submitKickUserCallback(String aChannel, Callback<String> aCallback) {
        this.kickUserListener.submit(aChannel, aCallback);
    }

    private boolean isForMe(IUserMessage aMsg) {
        return this.getIRCState().getNickname().equals(aMsg.getSource().getNick());
    }
}

