/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.theta;

import com.metamx.common.logger.Logger;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.memory.MemoryRegion;
import com.yahoo.sketches.memory.NativeMemory;
import com.yahoo.sketches.theta.SetOperation;
import com.yahoo.sketches.theta.Union;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.datasketches.theta.SketchAggregator;
import io.druid.segment.ObjectColumnSelector;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class SketchBufferAggregator
implements BufferAggregator {
    private static final Logger logger = new Logger(SketchAggregator.class);
    private final ObjectColumnSelector selector;
    private final int size;
    private final int maxIntermediateSize;
    private NativeMemory nm;
    private final Map<Integer, Union> unions = new HashMap<Integer, Union>();

    public SketchBufferAggregator(ObjectColumnSelector selector, int size, int maxIntermediateSize) {
        this.selector = selector;
        this.size = size;
        this.maxIntermediateSize = maxIntermediateSize;
    }

    public void init(ByteBuffer buf, int position) {
        if (this.nm == null) {
            this.nm = new NativeMemory(buf);
        }
        MemoryRegion mem = new MemoryRegion((Memory)this.nm, (long)position, (long)this.maxIntermediateSize);
        this.unions.put(position, (Union)SetOperation.builder().initMemory((Memory)mem).build(this.size, Family.UNION));
    }

    public void aggregate(ByteBuffer buf, int position) {
        Object update = this.selector.get();
        if (update == null) {
            return;
        }
        Union union = this.getUnion(buf, position);
        SketchAggregator.updateUnion(union, update);
    }

    public Object get(ByteBuffer buf, int position) {
        return this.getUnion(buf, position).getResult(true, null);
    }

    private Union getUnion(ByteBuffer buf, int position) {
        Union union = this.unions.get(position);
        if (union == null) {
            MemoryRegion mem = new MemoryRegion((Memory)this.nm, (long)position, (long)this.maxIntermediateSize);
            union = (Union)SetOperation.wrap((Memory)mem);
            this.unions.put(position, union);
        }
        return union;
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() {
        this.unions.clear();
    }
}

